/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.predicate;

import java.io.Serializable;
import org.apache.paimon.predicate.FieldRef;
import org.apache.paimon.utils.Preconditions;

public class SortValue
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final FieldRef field;
    private final SortDirection direction;
    private final NullOrdering nullOrdering;

    public SortValue(FieldRef field, SortDirection direction, NullOrdering nullOrdering) {
        this.field = (FieldRef)Preconditions.checkNotNull((Object)field);
        this.direction = (SortDirection)((Object)Preconditions.checkNotNull((Object)((Object)direction)));
        this.nullOrdering = (NullOrdering)((Object)Preconditions.checkNotNull((Object)((Object)nullOrdering)));
    }

    public FieldRef field() {
        return this.field;
    }

    public SortDirection direction() {
        return this.direction;
    }

    public NullOrdering nullOrdering() {
        return this.nullOrdering;
    }

    public String toString() {
        return String.format("%s %s %s", this.field.name(), this.direction.toString(), this.nullOrdering.toString());
    }

    public static enum SortDirection {
        ASCENDING("ASC"),
        DESCENDING("DESC");

        private final String name;

        private SortDirection(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum NullOrdering {
        NULLS_FIRST("NULLS FIRST"),
        NULLS_LAST("NULLS LAST");

        private final String name;

        private NullOrdering(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

