/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.casting;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.paimon.casting.AbstractCastRule;
import org.apache.paimon.casting.CastExecutor;
import org.apache.paimon.casting.CastExecutors;
import org.apache.paimon.casting.CastRulePredicate;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.GenericMap;
import org.apache.paimon.data.InternalMap;
import org.apache.paimon.shade.guava30.com.google.common.collect.Maps;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeFamily;
import org.apache.paimon.types.DataTypeRoot;
import org.apache.paimon.types.MapType;
import org.apache.paimon.types.VarCharType;
import org.apache.paimon.utils.StringUtils;

class StringToMapCastRule
extends AbstractCastRule<BinaryString, InternalMap> {
    static final StringToMapCastRule INSTANCE = new StringToMapCastRule();
    private static final Pattern BRACKET_MAP_PATTERN = Pattern.compile("^\\s*\\{(.*)\\}\\s*$");
    private static final Pattern FUNCTION_MAP_PATTERN = Pattern.compile("^\\s*MAP\\s*\\((.*)\\)\\s*$", 2);
    private static final Pattern ENTRY_PATTERN = Pattern.compile("(.+?)\\s*->\\s*(.+)");

    private StringToMapCastRule() {
        super(CastRulePredicate.builder().input(DataTypeFamily.CHARACTER_STRING).target(DataTypeRoot.MAP).build());
    }

    @Override
    public CastExecutor<BinaryString, InternalMap> create(DataType inputType, DataType targetType) {
        MapType mapType = (MapType)targetType;
        CastExecutor<BinaryString, Object> keyCastExecutor = this.createCastExecutor(mapType.getKeyType());
        CastExecutor<BinaryString, Object> valueCastExecutor = this.createCastExecutor(mapType.getValueType());
        return value -> this.parseMap((BinaryString)value, keyCastExecutor, valueCastExecutor);
    }

    private InternalMap parseMap(BinaryString value, CastExecutor<BinaryString, Object> keyCastExecutor, CastExecutor<BinaryString, Object> valueCastExecutor) {
        try {
            String str = value.toString().trim();
            if ("{}".equals(str) || "MAP()".equalsIgnoreCase(str)) {
                return new GenericMap(new HashMap());
            }
            return new GenericMap(this.parseDefaultMap(str, keyCastExecutor, valueCastExecutor));
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot parse '" + value + "' as MAP: " + e.getMessage(), e);
        }
    }

    private CastExecutor<BinaryString, Object> createCastExecutor(DataType targetType) {
        CastExecutor<BinaryString, Object> executor = CastExecutors.resolve((DataType)VarCharType.STRING_TYPE, targetType);
        if (executor == null) {
            throw new RuntimeException("Cannot cast string to type: " + targetType);
        }
        return executor;
    }

    private Map<Object, Object> parseDefaultMap(String str, CastExecutor<BinaryString, Object> keyCastExecutor, CastExecutor<BinaryString, Object> valueCastExecutor) {
        HashMap mapContent = Maps.newHashMap();
        Matcher bracketMatcher = BRACKET_MAP_PATTERN.matcher(str);
        if (bracketMatcher.matches()) {
            String content = bracketMatcher.group(1).trim();
            return this.parseMapEntry(content, keyCastExecutor, valueCastExecutor);
        }
        Matcher functionMatcher = FUNCTION_MAP_PATTERN.matcher(str);
        if (functionMatcher.matches()) {
            String functionContent = functionMatcher.group(1).trim();
            return this.parseFunctionDefaultMap(functionContent, keyCastExecutor, valueCastExecutor);
        }
        throw new RuntimeException("Invalid map format: " + str + ". Expected format: {k -> v} or MAP(k, v)");
    }

    private Map<Object, Object> parseFunctionDefaultMap(String content, CastExecutor<BinaryString, Object> keyCastExecutor, CastExecutor<BinaryString, Object> valueCastExecutor) {
        List<String> elements = this.splitMapEntries(content.trim());
        if (elements.size() % 2 != 0) {
            throw new RuntimeException("Invalid Function map format: odd number of elements");
        }
        return IntStream.range(0, elements.size() / 2).boxed().collect(Collectors.toMap(i -> this.parseValue(((String)elements.get(i * 2)).trim(), keyCastExecutor), i -> this.parseValue(((String)elements.get(i * 2 + 1)).trim(), valueCastExecutor)));
    }

    private Map<Object, Object> parseMapEntry(String content, CastExecutor<BinaryString, Object> keyCastExecutor, CastExecutor<BinaryString, Object> valueCastExecutor) {
        HashMap mapContent = Maps.newHashMap();
        for (String entry : this.splitMapEntries(content)) {
            Matcher entryMatcher = ENTRY_PATTERN.matcher(entry);
            if (!entryMatcher.matches()) {
                throw new RuntimeException("Invalid map entry format: " + entry);
            }
            mapContent.put(this.parseValue(entryMatcher.group(1).trim(), keyCastExecutor), this.parseValue(entryMatcher.group(2).trim(), valueCastExecutor));
        }
        return mapContent;
    }

    private Object parseValue(String valueStr, CastExecutor<BinaryString, Object> castExecutor) {
        return "null".equals(valueStr) ? null : castExecutor.cast(BinaryString.fromString(valueStr));
    }

    private List<String> splitMapEntries(String content) {
        ArrayList<String> entries = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        Stack<Character> bracketStack = new Stack<Character>();
        boolean inQuotes = false;
        boolean escaped = false;
        for (char c : content.toCharArray()) {
            if (escaped) {
                escaped = false;
            } else if (c == '\\') {
                escaped = true;
            } else if (c == '\"') {
                inQuotes = !inQuotes;
            } else if (!inQuotes) {
                if (StringUtils.isOpenBracket((char)c)) {
                    bracketStack.push(Character.valueOf(c));
                } else if (StringUtils.isCloseBracket((char)c) && !bracketStack.isEmpty()) {
                    bracketStack.pop();
                } else if (c == ',' && bracketStack.isEmpty()) {
                    this.addCurrentEntry(entries, current);
                    continue;
                }
            }
            current.append(c);
        }
        this.addCurrentEntry(entries, current);
        return entries;
    }

    private void addCurrentEntry(List<String> entries, StringBuilder current) {
        if (current.length() > 0) {
            entries.add(current.toString());
            current.setLength(0);
        }
    }
}

