/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.fileindex.rangebitmap.dictionary.chunked;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.paimon.fileindex.rangebitmap.dictionary.chunked.AbstractChunk;
import org.apache.paimon.fileindex.rangebitmap.dictionary.chunked.KeyFactory;
import org.apache.paimon.fs.SeekableInputStream;
import org.apache.paimon.utils.IOUtils;

public class FixedLengthChunk
extends AbstractChunk {
    public static final byte CURRENT_VERSION = 1;
    private final byte version;
    private final Object key;
    private final int code;
    private final int offset;
    private final int fixedLength;
    private int size;
    private int keysBaseOffset;
    private int keysLength;
    private SeekableInputStream in;
    private ByteBuffer keys;
    private KeyFactory.KeySerializer serializer;
    private KeyFactory.KeyDeserializer deserializer;

    public FixedLengthChunk(Object key, int code, int offset, int limitedSerializedSizeInBytes, KeyFactory.KeySerializer serializer, Comparator<Object> comparator) {
        super(comparator);
        this.version = 1;
        this.key = key;
        this.code = code;
        this.offset = offset;
        this.size = 0;
        this.keys = ByteBuffer.allocate(limitedSerializedSizeInBytes);
        this.serializer = serializer;
        this.fixedLength = this.serializer.serializedSizeInBytes(key);
    }

    public FixedLengthChunk(ByteBuffer headers, int keysBaseOffset, SeekableInputStream in, KeyFactory.KeyDeserializer deserializer, Comparator<Object> comparator) {
        super(comparator);
        this.version = headers.get();
        if (this.version > 1) {
            throw new IllegalArgumentException("version out of range");
        }
        this.key = deserializer.deserialize(headers);
        this.code = headers.getInt();
        this.offset = headers.getInt();
        this.size = headers.getInt();
        this.keysLength = headers.getInt();
        this.fixedLength = headers.getInt();
        this.keysBaseOffset = keysBaseOffset;
        this.in = in;
        this.deserializer = deserializer;
    }

    @Override
    protected int size() {
        return this.size;
    }

    @Override
    protected Object get(int index) {
        if (this.keys == null) {
            try {
                this.in.seek(this.keysBaseOffset + this.offset);
                byte[] bytes = new byte[this.keysLength];
                IOUtils.readFully((InputStream)this.in, bytes);
                this.keys = ByteBuffer.wrap(bytes);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.keys.position(index * this.fixedLength);
        return this.deserializer.deserialize(this.keys);
    }

    @Override
    public boolean tryAdd(Object key) {
        if (this.fixedLength > this.keys.remaining()) {
            return false;
        }
        this.serializer.serialize(this.keys, key);
        ++this.size;
        return true;
    }

    @Override
    public Object key() {
        return this.key;
    }

    @Override
    public int code() {
        return this.code;
    }

    @Override
    public byte[] serializeChunk() {
        this.keys.flip();
        int serializedSizeInBytes = 0;
        ++serializedSizeInBytes;
        serializedSizeInBytes += this.fixedLength;
        serializedSizeInBytes += 4;
        serializedSizeInBytes += 4;
        serializedSizeInBytes += 4;
        serializedSizeInBytes += 4;
        ByteBuffer buffer = ByteBuffer.allocate(serializedSizeInBytes += 4);
        buffer.put(this.version);
        this.serializer.serialize(buffer, this.key);
        buffer.putInt(this.code);
        buffer.putInt(this.offset);
        buffer.putInt(this.size);
        buffer.putInt(this.keys.limit());
        buffer.putInt(this.fixedLength);
        return buffer.array();
    }

    @Override
    public byte[] serializeKeys() {
        return Arrays.copyOf(this.keys.array(), this.keys.limit());
    }
}

