/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.reader;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.reader.DataEvolutionIterator;
import org.apache.paimon.reader.DataEvolutionRow;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.utils.IOUtils;
import org.apache.paimon.utils.Preconditions;

public class DataEvolutionFileReader
implements RecordReader<InternalRow> {
    private final int[] rowOffsets;
    private final int[] fieldOffsets;
    private final RecordReader<InternalRow>[] readers;

    public DataEvolutionFileReader(int[] rowOffsets, int[] fieldOffsets, RecordReader<InternalRow>[] readers) {
        Preconditions.checkArgument((rowOffsets != null ? 1 : 0) != 0, (Object)"Row offsets must not be null");
        Preconditions.checkArgument((fieldOffsets != null ? 1 : 0) != 0, (Object)"Field offsets must not be null");
        Preconditions.checkArgument((rowOffsets.length == fieldOffsets.length ? 1 : 0) != 0, (Object)"Row offsets and field offsets must have the same length");
        Preconditions.checkArgument((rowOffsets.length > 0 ? 1 : 0) != 0, (Object)"Row offsets must not be empty");
        Preconditions.checkArgument((readers != null && readers.length > 1 ? 1 : 0) != 0, (Object)"Readers should be more than 1");
        this.rowOffsets = rowOffsets;
        this.fieldOffsets = fieldOffsets;
        this.readers = readers;
    }

    @Override
    @Nullable
    public RecordReader.RecordIterator<InternalRow> readBatch() throws IOException {
        DataEvolutionRow row = new DataEvolutionRow(this.readers.length, this.rowOffsets, this.fieldOffsets);
        RecordReader.RecordIterator[] iterators = new RecordReader.RecordIterator[this.readers.length];
        for (int i = 0; i < this.readers.length; ++i) {
            RecordReader<InternalRow> reader = this.readers[i];
            if (reader == null) continue;
            RecordReader.RecordIterator<InternalRow> batch = reader.readBatch();
            if (batch == null) {
                return null;
            }
            iterators[i] = batch;
        }
        return new DataEvolutionIterator(row, iterators);
    }

    @Override
    public void close() throws IOException {
        try {
            IOUtils.closeAll(this.readers);
        }
        catch (Exception e) {
            throw new IOException("Failed to close inner readers", e);
        }
    }
}

