/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.security;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.paimon.security.KerberosLoginProvider;
import org.apache.paimon.security.SecurityConfiguration;
import org.apache.paimon.utils.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopModule {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopModule.class);
    private final SecurityConfiguration securityConfig;
    private final Configuration hadoopConfiguration;

    public HadoopModule(SecurityConfiguration securityConfiguration, Configuration hadoopConfiguration) {
        this.securityConfig = (SecurityConfiguration)Preconditions.checkNotNull((Object)securityConfiguration);
        this.hadoopConfiguration = (Configuration)Preconditions.checkNotNull((Object)hadoopConfiguration);
    }

    public void install() throws IOException {
        UserGroupInformation loginUser;
        UserGroupInformation.setConfiguration((Configuration)this.hadoopConfiguration);
        KerberosLoginProvider kerberosLoginProvider = new KerberosLoginProvider(this.securityConfig);
        if (kerberosLoginProvider.isLoginPossible()) {
            String fileLocation;
            kerberosLoginProvider.doLogin();
            loginUser = UserGroupInformation.getLoginUser();
            if (loginUser.isFromKeytab() && (fileLocation = System.getenv("HADOOP_TOKEN_FILE_LOCATION")) != null) {
                Credentials credentials = Credentials.readTokenStorageFile((File)new File(fileLocation), (Configuration)this.hadoopConfiguration);
                loginUser.addCredentials(credentials);
            }
        } else {
            loginUser = UserGroupInformation.getLoginUser();
        }
        LOG.info("Hadoop user set to {}", (Object)loginUser);
        boolean isKerberosSecurityEnabled = KerberosLoginProvider.hasUserKerberosAuthMethod(loginUser);
        LOG.info("Kerberos security is {}.", (Object)(isKerberosSecurityEnabled ? "enabled" : "disabled"));
        if (isKerberosSecurityEnabled) {
            LOG.info("Kerberos credentials are {}.", (Object)(loginUser.hasKerberosCredentials() ? "valid" : "invalid"));
        }
    }
}

