/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.paimon.flink.action.Action;
import org.apache.paimon.flink.action.ActionFactory;
import org.apache.paimon.flink.action.CompactAction;
import org.apache.paimon.flink.action.MultipleParameterToolAdapter;
import org.apache.paimon.flink.action.SortCompactAction;

public class CompactActionFactory
implements ActionFactory {
    public static final String IDENTIFIER = "compact";
    private static final String ORDER_STRATEGY = "order_strategy";
    private static final String ORDER_BY = "order_by";

    @Override
    public String identifier() {
        return IDENTIFIER;
    }

    @Override
    public Optional<Action> create(MultipleParameterToolAdapter params) {
        Tuple3<String, String, String> tablePath = this.getTablePath(params);
        Map<String, String> catalogConfig = this.optionalConfigMap(params, "catalog_conf");
        CompactAction action = params.has(ORDER_STRATEGY) ? new SortCompactAction((String)tablePath.f0, (String)tablePath.f1, (String)tablePath.f2, catalogConfig, this.optionalConfigMap(params, "table_conf")).withOrderStrategy(params.get(ORDER_STRATEGY)).withOrderColumns(this.getRequiredValue(params, ORDER_BY).split(",")) : new CompactAction((String)tablePath.f0, (String)tablePath.f1, (String)tablePath.f2, catalogConfig, this.optionalConfigMap(params, "table_conf"));
        if (params.has("partition")) {
            List<Map<String, String>> partitions = this.getPartitions(params);
            action.withPartitions(partitions);
        }
        return Optional.of(action);
    }

    @Override
    public void printHelp() {
        System.out.println("Action \"compact\" runs a dedicated job for compacting specified table.");
        System.out.println();
        System.out.println("Syntax:");
        System.out.println("  compact --warehouse <warehouse_path> --database <database_name> --table <table_name> [--partition <partition_name>][--order_strategy <order_strategy>][--table_conf <key>=<value>][--order_by <order_columns>]");
        System.out.println("  compact --warehouse s3://path/to/warehouse --database <database_name> --table <table_name> [--catalog_conf <paimon_catalog_conf> [--catalog_conf <paimon_catalog_conf> ...]]");
        System.out.println("  compact --path <table_path> [--partition <partition_name>]");
        System.out.println();
        System.out.println("Partition name syntax:");
        System.out.println("  key1=value1,key2=value2,...");
        System.out.println();
        System.out.println("Note:");
        System.out.println("  order compact now only support append-only table with bucket=-1, please don't specify --order_strategy parameter if your table does not meet the request");
        System.out.println("  order_strategy now only support zorder in batch mode");
        System.out.println();
        System.out.println("Examples:");
        System.out.println("  compact --warehouse hdfs:///path/to/warehouse --database test_db --table test_table");
        System.out.println("  compact --path hdfs:///path/to/warehouse/test_db.db/test_table --partition dt=20221126,hh=08");
        System.out.println("  compact --warehouse hdfs:///path/to/warehouse --database test_db --table test_table --partition dt=20221126,hh=08 --partition dt=20221127,hh=09");
        System.out.println("  compact --warehouse s3:///path/to/warehouse --database test_db --table test_table --order_strategy zorder --order_by a,b,c --table_conf sink.parallelism=9 --catalog_conf s3.endpoint=https://****.com --catalog_conf s3.access-key=***** --catalog_conf s3.secret-key=***** ");
    }
}

