/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc.kafka;

import java.io.IOException;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.connector.kafka.source.reader.deserializer.KafkaRecordDeserializationSchema;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.flink.util.Collector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KafkaValueOnlyDeserializationSchemaWrapper<T>
implements KafkaRecordDeserializationSchema<T> {
    private static final long serialVersionUID = 1L;
    private final DeserializationSchema<T> deserializationSchema;
    private static final Logger LOG = LoggerFactory.getLogger(KafkaValueOnlyDeserializationSchemaWrapper.class);

    KafkaValueOnlyDeserializationSchemaWrapper(DeserializationSchema<T> deserializationSchema) {
        this.deserializationSchema = deserializationSchema;
    }

    public void open(DeserializationSchema.InitializationContext context) throws Exception {
        this.deserializationSchema.open(context);
    }

    public void deserialize(ConsumerRecord<byte[], byte[]> message, Collector<T> out) throws IOException {
        if (message.value() != null) {
            this.deserializationSchema.deserialize((byte[])message.value(), out);
        } else {
            LOG.info("Found null message value:\n{}\nThis message will be ignored. It might be produced by tombstone-event, please check your Debezium and Kafka configuration.", message);
        }
    }

    public TypeInformation<T> getProducedType() {
        return this.deserializationSchema.getProducedType();
    }
}

