/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.procedure.privilege;

import org.apache.flink.table.procedure.ProcedureContext;
import org.apache.paimon.flink.procedure.ProcedureBase;
import org.apache.paimon.options.Options;
import org.apache.paimon.privilege.FileBasedPrivilegeManager;
import org.apache.paimon.privilege.PrivilegedCatalog;

public class InitFileBasedPrivilegeProcedure
extends ProcedureBase {
    public static final String IDENTIFIER = "init_file_based_privilege";

    public String[] call(ProcedureContext procedureContext, String rootPassword) {
        if (this.catalog instanceof PrivilegedCatalog) {
            throw new IllegalArgumentException("Catalog is already a PrivilegedCatalog");
        }
        Options options = new Options(this.catalog.options());
        FileBasedPrivilegeManager privilegeManager = new FileBasedPrivilegeManager(this.catalog.warehouse(), this.catalog.fileIO(), options.get(PrivilegedCatalog.USER), options.get(PrivilegedCatalog.PASSWORD));
        privilegeManager.initializePrivilege(rootPassword);
        return new String[]{"Privilege system is successfully enabled. Please drop and re-create the catalog."};
    }

    @Override
    public String identifier() {
        return IDENTIFIER;
    }
}

