/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc.schema;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.flink.action.cdc.schema.AllMergedJdbcTableInfo;
import org.apache.paimon.flink.action.cdc.schema.JdbcTableInfo;
import org.apache.paimon.flink.action.cdc.schema.ShardsMergedJdbcTableInfo;
import org.apache.paimon.flink.action.cdc.schema.UnmergedJdbcTableInfo;
import org.apache.paimon.schema.Schema;

public class JdbcSchemasInfo {
    private final List<JdbcSchemaInfo> schemasInfo = new ArrayList<JdbcSchemaInfo>();

    public void addSchema(Identifier identifier, Schema schema) {
        this.addSchema(identifier, null, schema);
    }

    public void addSchema(Identifier identifier, String schemaName, Schema schema) {
        JdbcSchemaInfo schemaInfo = new JdbcSchemaInfo(identifier, schemaName, !schema.primaryKeys().isEmpty(), schema);
        this.schemasInfo.add(schemaInfo);
    }

    public List<JdbcSchemaInfo> pkTables() {
        return this.schemasInfo.stream().filter(JdbcSchemaInfo::isPkTable).collect(Collectors.toList());
    }

    public List<Identifier> nonPkTables() {
        return this.schemasInfo.stream().filter(jdbcSchemaInfo -> !jdbcSchemaInfo.isPkTable()).map(JdbcSchemaInfo::identifier).collect(Collectors.toList());
    }

    public JdbcTableInfo mergeAll() {
        boolean initialized = false;
        AllMergedJdbcTableInfo merged = new AllMergedJdbcTableInfo();
        for (JdbcSchemaInfo jdbcSchemaInfo : this.schemasInfo) {
            if (!jdbcSchemaInfo.isPkTable()) continue;
            Identifier id = jdbcSchemaInfo.identifier();
            Schema schema = jdbcSchemaInfo.schema();
            if (!initialized) {
                merged.init(id, schema);
                initialized = true;
                continue;
            }
            merged.merge(id, schema);
        }
        return merged;
    }

    public List<JdbcTableInfo> toMySqlTableInfos(boolean mergeShards) {
        if (mergeShards) {
            return this.mergeShards();
        }
        return this.schemasInfo.stream().filter(JdbcSchemaInfo::isPkTable).map(e -> new UnmergedJdbcTableInfo(e.identifier(), e.schema())).collect(Collectors.toList());
    }

    private List<JdbcTableInfo> mergeShards() {
        HashMap<String, ShardsMergedJdbcTableInfo> nameSchemaMap = new HashMap<String, ShardsMergedJdbcTableInfo>();
        for (JdbcSchemaInfo jdbcSchemaInfo : this.schemasInfo) {
            if (!jdbcSchemaInfo.isPkTable()) continue;
            Identifier id = jdbcSchemaInfo.identifier();
            String tableName = id.getObjectName();
            Schema toBeMerged = jdbcSchemaInfo.schema();
            ShardsMergedJdbcTableInfo current = (ShardsMergedJdbcTableInfo)nameSchemaMap.get(tableName);
            if (current == null) {
                current = new ShardsMergedJdbcTableInfo();
                current.init(id, toBeMerged);
                nameSchemaMap.put(tableName, current);
                continue;
            }
            nameSchemaMap.put(tableName, current.merge(id, toBeMerged));
        }
        return new ArrayList<JdbcTableInfo>(nameSchemaMap.values());
    }

    public static class JdbcSchemaInfo {
        private final Identifier identifier;
        private final String schemaName;
        private final boolean isPkTable;
        private final Schema schema;

        public JdbcSchemaInfo(Identifier identifier, String schemaName, boolean isPkTable, Schema schema) {
            this.identifier = identifier;
            this.schemaName = schemaName;
            this.isPkTable = isPkTable;
            this.schema = schema;
        }

        public Identifier identifier() {
            return this.identifier;
        }

        public String schemaName() {
            return this.schemaName;
        }

        public boolean isPkTable() {
            return this.isPkTable;
        }

        public Schema schema() {
            return this.schema;
        }
    }
}

