/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.compact;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.append.UnawareAppendCompactionTask;
import org.apache.paimon.flink.sink.Committable;
import org.apache.paimon.operation.AppendOnlyFileStoreWrite;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.sink.CommitMessage;
import org.apache.paimon.table.sink.TableCommitImpl;

public class UnawareBucketCompactor {
    private final FileStoreTable table;
    private final String commitUser;
    private final transient AppendOnlyFileStoreWrite write;
    protected final transient Queue<Future<CommitMessage>> result;
    private final transient Supplier<ExecutorService> compactExecutorsupplier;

    public UnawareBucketCompactor(FileStoreTable table, String commitUser, Supplier<ExecutorService> lazyCompactExecutor) {
        this.table = table;
        this.commitUser = commitUser;
        this.write = (AppendOnlyFileStoreWrite)table.store().newWrite(commitUser);
        this.result = new LinkedList<Future<CommitMessage>>();
        this.compactExecutorsupplier = lazyCompactExecutor;
    }

    public void processElement(UnawareAppendCompactionTask task) throws Exception {
        this.result.add(this.compactExecutorsupplier.get().submit(() -> task.doCompact(this.table, this.write)));
    }

    public void close() throws Exception {
        this.shutdown();
    }

    @VisibleForTesting
    void shutdown() throws Exception {
        Future resultFuture;
        ArrayList<CommitMessage> messages = new ArrayList<CommitMessage>();
        Iterator iterator = this.result.iterator();
        while (iterator.hasNext() && (resultFuture = (Future)iterator.next()).isDone()) {
            try {
                messages.add((CommitMessage)resultFuture.get());
            }
            catch (Exception exception) {}
        }
        if (messages.isEmpty()) {
            return;
        }
        try (TableCommitImpl tableCommit = this.table.newCommit(this.commitUser);){
            tableCommit.abort(messages);
        }
    }

    public List<Committable> prepareCommit(boolean waitCompaction, long checkpointId) throws IOException {
        ArrayList<CommitMessage> tempList = new ArrayList<CommitMessage>();
        try {
            Future<CommitMessage> future;
            while (!this.result.isEmpty() && ((future = this.result.peek()).isDone() || waitCompaction)) {
                this.result.poll();
                tempList.add(future.get());
            }
            return tempList.stream().map(s -> new Committable(checkpointId, Committable.Kind.FILE, s)).collect(Collectors.toList());
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while waiting tasks done.", e);
        }
        catch (Exception e) {
            throw new RuntimeException("Encountered an error while do compaction", e);
        }
    }

    public Iterable<Future<CommitMessage>> result() {
        return this.result;
    }
}

