/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.parquet.reader;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.paimon.data.columnar.ColumnVector;
import org.apache.paimon.data.columnar.heap.AbstractHeapVector;
import org.apache.paimon.data.columnar.heap.HeapArrayVector;
import org.apache.paimon.data.columnar.heap.HeapMapVector;
import org.apache.paimon.data.columnar.heap.HeapRowVector;
import org.apache.paimon.data.columnar.writable.WritableColumnVector;
import org.apache.paimon.format.parquet.position.CollectionPosition;
import org.apache.paimon.format.parquet.position.LevelDelegation;
import org.apache.paimon.format.parquet.reader.ColumnReader;
import org.apache.paimon.format.parquet.reader.NestedPositionUtil;
import org.apache.paimon.format.parquet.reader.NestedPrimitiveColumnReader;
import org.apache.paimon.format.parquet.type.ParquetField;
import org.apache.paimon.format.parquet.type.ParquetGroupField;
import org.apache.paimon.format.parquet.type.ParquetPrimitiveField;
import org.apache.paimon.shade.org.apache.parquet.column.ColumnDescriptor;
import org.apache.paimon.shade.org.apache.parquet.column.page.PageReadStore;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.MapType;
import org.apache.paimon.types.MultisetType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.Pair;
import org.apache.paimon.utils.Preconditions;

public class NestedColumnReader
implements ColumnReader<WritableColumnVector> {
    private final Map<ColumnDescriptor, NestedPrimitiveColumnReader> columnReaders;
    private final boolean isUtcTimestamp;
    private final PageReadStore pages;
    private final ParquetField field;

    public NestedColumnReader(boolean isUtcTimestamp, PageReadStore pages, ParquetField field) {
        this.isUtcTimestamp = isUtcTimestamp;
        this.pages = pages;
        this.field = field;
        this.columnReaders = new HashMap<ColumnDescriptor, NestedPrimitiveColumnReader>();
    }

    @Override
    public void readToVector(int readNumber, WritableColumnVector vector) throws IOException {
        this.readData(this.field, readNumber, vector, false, false, false);
    }

    private Pair<LevelDelegation, WritableColumnVector> readData(ParquetField field, int readNumber, ColumnVector vector, boolean inside, boolean readRowField, boolean readMapKey) throws IOException {
        if (field.getType() instanceof RowType) {
            return this.readRow((ParquetGroupField)field, readNumber, vector, inside);
        }
        if (field.getType() instanceof MapType || field.getType() instanceof MultisetType) {
            return this.readMap((ParquetGroupField)field, readNumber, vector, inside, readRowField);
        }
        if (field.getType() instanceof ArrayType) {
            return this.readArray((ParquetGroupField)field, readNumber, vector, inside, readRowField);
        }
        return this.readPrimitive((ParquetPrimitiveField)field, readNumber, vector, readRowField, readMapKey);
    }

    private Pair<LevelDelegation, WritableColumnVector> readRow(ParquetGroupField field, int readNumber, ColumnVector vector, boolean inside) throws IOException {
        HeapRowVector heapRowVector = (HeapRowVector)vector;
        LevelDelegation longest = null;
        List<ParquetField> children = field.getChildren();
        WritableColumnVector[] childrenVectors = heapRowVector.getFields();
        WritableColumnVector[] finalChildrenVectors = new WritableColumnVector[childrenVectors.length];
        for (int i = 0; i < children.size(); ++i) {
            Pair<LevelDelegation, WritableColumnVector> tuple = this.readData(children.get(i), readNumber, childrenVectors[i], true, true, false);
            LevelDelegation current = tuple.getLeft();
            if (longest == null) {
                longest = current;
            } else if (current.getDefinitionLevel().length > longest.getDefinitionLevel().length) {
                longest = current;
            }
            finalChildrenVectors[i] = tuple.getRight();
        }
        if (longest == null) {
            throw new RuntimeException(String.format("Row field does not have any children: %s.", field));
        }
        int len = ((AbstractHeapVector)finalChildrenVectors[0]).getLen();
        boolean[] isNull = new boolean[len];
        Arrays.fill(isNull, true);
        boolean hasNull = false;
        for (int i = 0; i < len; ++i) {
            for (WritableColumnVector child : finalChildrenVectors) {
                isNull[i] = isNull[i] && child.isNullAt(i);
            }
            if (!isNull[i]) continue;
            hasNull = true;
        }
        if (inside) {
            heapRowVector = new HeapRowVector(len, finalChildrenVectors);
        } else {
            heapRowVector.setFields(finalChildrenVectors);
        }
        if (hasNull) {
            NestedColumnReader.setFieldNullFlag(isNull, heapRowVector);
        }
        return Pair.of(longest, heapRowVector);
    }

    private Pair<LevelDelegation, WritableColumnVector> readMap(ParquetGroupField field, int readNumber, ColumnVector vector, boolean inside, boolean readRowField) throws IOException {
        HeapMapVector mapVector = (HeapMapVector)vector;
        mapVector.reset();
        List<ParquetField> children = field.getChildren();
        Preconditions.checkArgument(children.size() == 2, "Maps must have two type parameters, found %s", children.size());
        Pair<LevelDelegation, WritableColumnVector> keyTuple = this.readData(children.get(0), readNumber, mapVector.getKeyColumnVector(), true, false, true);
        Pair<LevelDelegation, WritableColumnVector> valueTuple = this.readData(children.get(1), readNumber, mapVector.getValueColumnVector(), true, false, false);
        LevelDelegation levelDelegation = keyTuple.getLeft();
        CollectionPosition collectionPosition = NestedPositionUtil.calculateCollectionOffsets(field, levelDelegation.getDefinitionLevel(), levelDelegation.getRepetitionLevel(), readRowField);
        if (inside) {
            mapVector = new HeapMapVector(collectionPosition.getValueCount(), keyTuple.getRight(), valueTuple.getRight());
        } else {
            mapVector.setKeys(keyTuple.getRight());
            mapVector.setValues(valueTuple.getRight());
        }
        if (collectionPosition.getIsNull() != null) {
            NestedColumnReader.setFieldNullFlag(collectionPosition.getIsNull(), mapVector);
        }
        mapVector.setLengths(collectionPosition.getLength());
        mapVector.setOffsets(collectionPosition.getOffsets());
        return Pair.of(levelDelegation, mapVector);
    }

    private Pair<LevelDelegation, WritableColumnVector> readArray(ParquetGroupField field, int readNumber, ColumnVector vector, boolean inside, boolean readRowField) throws IOException {
        HeapArrayVector arrayVector = (HeapArrayVector)vector;
        arrayVector.reset();
        List<ParquetField> children = field.getChildren();
        Preconditions.checkArgument(children.size() == 1, "Arrays must have a single type parameter, found %s", children.size());
        Pair<LevelDelegation, WritableColumnVector> tuple = this.readData(children.get(0), readNumber, arrayVector.getChild(), true, false, false);
        LevelDelegation levelDelegation = tuple.getLeft();
        CollectionPosition collectionPosition = NestedPositionUtil.calculateCollectionOffsets(field, levelDelegation.getDefinitionLevel(), levelDelegation.getRepetitionLevel(), readRowField);
        if (inside) {
            arrayVector = new HeapArrayVector(collectionPosition.getValueCount(), tuple.getRight());
        } else {
            arrayVector.setChild(tuple.getRight());
        }
        if (collectionPosition.getIsNull() != null) {
            NestedColumnReader.setFieldNullFlag(collectionPosition.getIsNull(), arrayVector);
        }
        arrayVector.setLengths(collectionPosition.getLength());
        arrayVector.setOffsets(collectionPosition.getOffsets());
        return Pair.of(levelDelegation, arrayVector);
    }

    private Pair<LevelDelegation, WritableColumnVector> readPrimitive(ParquetPrimitiveField field, int readNumber, ColumnVector vector, boolean readRowField, boolean readMapKey) throws IOException {
        ColumnDescriptor descriptor = field.getDescriptor();
        NestedPrimitiveColumnReader reader = this.columnReaders.get(descriptor);
        if (reader == null) {
            reader = new NestedPrimitiveColumnReader(descriptor, this.pages.getPageReader(descriptor), this.isUtcTimestamp, descriptor.getPrimitiveType(), field.getType(), readRowField, readMapKey);
            this.columnReaders.put(descriptor, reader);
        }
        WritableColumnVector writableColumnVector = reader.readAndNewVector(readNumber, (WritableColumnVector)vector);
        return Pair.of(reader.getLevelDelegation(), writableColumnVector);
    }

    private static void setFieldNullFlag(boolean[] nullFlags, AbstractHeapVector vector) {
        for (int index = 0; index < vector.getLen() && index < nullFlags.length; ++index) {
            if (!nullFlags[index]) continue;
            vector.setNullAt(index);
        }
    }
}

