/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.iceberg.manifest;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.Decimal;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DecimalType;

public class IcebergConversions {
    private static final ThreadLocal<CharsetEncoder> ENCODER = ThreadLocal.withInitial(StandardCharsets.UTF_8::newEncoder);
    private static final ThreadLocal<CharsetDecoder> DECODER = ThreadLocal.withInitial(StandardCharsets.UTF_8::newDecoder);

    private IcebergConversions() {
    }

    public static ByteBuffer toByteBuffer(DataType type, Object value) {
        switch (type.getTypeRoot()) {
            case BOOLEAN: {
                return ByteBuffer.allocate(1).put(0, (Boolean)value != false ? (byte)1 : 0);
            }
            case INTEGER: 
            case DATE: {
                return ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(0, (Integer)value);
            }
            case BIGINT: {
                return ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong(0, (Long)value);
            }
            case FLOAT: {
                return ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putFloat(0, ((Float)value).floatValue());
            }
            case DOUBLE: {
                return ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putDouble(0, (Double)value);
            }
            case CHAR: 
            case VARCHAR: {
                CharBuffer buffer = CharBuffer.wrap(value.toString());
                try {
                    return ENCODER.get().encode(buffer);
                }
                catch (CharacterCodingException e) {
                    throw new RuntimeException("Failed to encode value as UTF-8: " + value, e);
                }
            }
            case BINARY: 
            case VARBINARY: {
                return ByteBuffer.wrap((byte[])value);
            }
            case DECIMAL: {
                Decimal decimal = (Decimal)value;
                return ByteBuffer.wrap(decimal.toUnscaledBytes());
            }
        }
        throw new UnsupportedOperationException("Cannot serialize type: " + type);
    }

    public static Object toPaimonObject(DataType type, byte[] bytes) {
        switch (type.getTypeRoot()) {
            case BOOLEAN: {
                return bytes[0] != 0;
            }
            case INTEGER: 
            case DATE: {
                return ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).getInt();
            }
            case BIGINT: {
                return ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).getLong();
            }
            case FLOAT: {
                return Float.valueOf(ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).getFloat());
            }
            case DOUBLE: {
                return ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).getDouble();
            }
            case CHAR: 
            case VARCHAR: {
                try {
                    return BinaryString.fromString(DECODER.get().decode(ByteBuffer.wrap(bytes)).toString());
                }
                catch (CharacterCodingException e) {
                    throw new RuntimeException("Failed to decode bytes as UTF-8", e);
                }
            }
            case BINARY: 
            case VARBINARY: {
                return bytes;
            }
            case DECIMAL: {
                DecimalType decimalType = (DecimalType)type;
                return Decimal.fromUnscaledBytes(bytes, decimalType.getPrecision(), decimalType.getScale());
            }
        }
        throw new UnsupportedOperationException("Cannot deserialize type: " + type);
    }
}

