/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.io.BundleRecords;
import org.apache.paimon.io.FileWriter;
import org.apache.paimon.io.SingleFileWriter;
import org.apache.paimon.utils.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RollingFileWriter<T, R>
implements FileWriter<T, List<R>> {
    private static final Logger LOG = LoggerFactory.getLogger(RollingFileWriter.class);
    private static final int CHECK_ROLLING_RECORD_CNT = 1000;
    private final Supplier<? extends SingleFileWriter<T, R>> writerFactory;
    private final long targetFileSize;
    private final List<SingleFileWriter.AbortExecutor> closedWriters;
    private final List<R> results;
    private SingleFileWriter<T, R> currentWriter = null;
    private long recordCount = 0L;
    private boolean closed = false;

    public RollingFileWriter(Supplier<? extends SingleFileWriter<T, R>> writerFactory, long targetFileSize) {
        this.writerFactory = writerFactory;
        this.targetFileSize = targetFileSize;
        this.results = new ArrayList<R>();
        this.closedWriters = new ArrayList<SingleFileWriter.AbortExecutor>();
    }

    @VisibleForTesting
    public long targetFileSize() {
        return this.targetFileSize;
    }

    @VisibleForTesting
    boolean rollingFile() throws IOException {
        return this.currentWriter.reachTargetSize(this.recordCount % 1000L == 0L, this.targetFileSize);
    }

    @Override
    public void write(T row) throws IOException {
        try {
            if (this.currentWriter == null) {
                this.openCurrentWriter();
            }
            this.currentWriter.write(row);
            ++this.recordCount;
            if (this.rollingFile()) {
                this.closeCurrentWriter();
            }
        }
        catch (Throwable e) {
            LOG.warn("Exception occurs when writing file " + (this.currentWriter == null ? null : this.currentWriter.path()) + ". Cleaning up.", e);
            this.abort();
            throw e;
        }
    }

    public void writeBundle(BundleRecords bundle) throws IOException {
        try {
            if (this.currentWriter == null) {
                this.openCurrentWriter();
            }
            this.currentWriter.writeBundle(bundle);
            this.recordCount += bundle.rowCount();
            if (this.rollingFile()) {
                this.closeCurrentWriter();
            }
        }
        catch (Throwable e) {
            LOG.warn("Exception occurs when writing file " + (this.currentWriter == null ? null : this.currentWriter.path()) + ". Cleaning up.", e);
            this.abort();
            throw e;
        }
    }

    private void openCurrentWriter() {
        this.currentWriter = this.writerFactory.get();
    }

    private void closeCurrentWriter() throws IOException {
        if (this.currentWriter == null) {
            return;
        }
        this.currentWriter.close();
        this.closedWriters.add(this.currentWriter.abortExecutor());
        this.results.add(this.currentWriter.result());
        this.currentWriter = null;
    }

    @Override
    public long recordCount() {
        return this.recordCount;
    }

    @Override
    public void abort() {
        if (this.currentWriter != null) {
            this.currentWriter.abort();
        }
        for (SingleFileWriter.AbortExecutor abortExecutor : this.closedWriters) {
            abortExecutor.abort();
        }
    }

    @Override
    public List<R> result() {
        Preconditions.checkState(this.closed, "Cannot access the results unless close all writers.");
        return this.results;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        try {
            this.closeCurrentWriter();
        }
        catch (IOException e) {
            LOG.warn("Exception occurs when writing file " + this.currentWriter.path() + ". Cleaning up.", (Throwable)e);
            this.abort();
            throw e;
        }
        finally {
            this.closed = true;
        }
    }
}

