/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.io;

import java.io.IOException;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.format.FormatWriterFactory;
import org.apache.paimon.format.SimpleColStats;
import org.apache.paimon.format.SimpleStatsCollector;
import org.apache.paimon.format.SimpleStatsExtractor;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.io.BundleRecords;
import org.apache.paimon.io.SingleFileWriter;
import org.apache.paimon.statistics.SimpleColStatsCollector;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.Preconditions;

public abstract class StatsCollectingSingleFileWriter<T, R>
extends SingleFileWriter<T, R> {
    @Nullable
    private final SimpleStatsExtractor simpleStatsExtractor;
    @Nullable
    private SimpleStatsCollector simpleStatsCollector = null;

    public StatsCollectingSingleFileWriter(FileIO fileIO, FormatWriterFactory factory, Path path, Function<T, InternalRow> converter, RowType writeSchema, @Nullable SimpleStatsExtractor simpleStatsExtractor, String compression, SimpleColStatsCollector.Factory[] statsCollectors, boolean asyncWrite) {
        super(fileIO, factory, path, converter, compression, asyncWrite);
        this.simpleStatsExtractor = simpleStatsExtractor;
        if (this.simpleStatsExtractor == null) {
            this.simpleStatsCollector = new SimpleStatsCollector(writeSchema, statsCollectors);
        }
        Preconditions.checkArgument(statsCollectors.length == writeSchema.getFieldCount(), "The stats collector is not aligned to write schema.");
    }

    @Override
    public void write(T record) throws IOException {
        InternalRow rowData = this.writeImpl(record);
        if (this.simpleStatsCollector != null && !this.simpleStatsCollector.isDisabled()) {
            this.simpleStatsCollector.collect(rowData);
        }
    }

    @Override
    public void writeBundle(BundleRecords bundle) throws IOException {
        Preconditions.checkState(this.simpleStatsExtractor != null, "Can't write bundle without simpleStatsExtractor, we may lose all the statistical information");
        super.writeBundle(bundle);
    }

    public SimpleColStats[] fieldStats() throws IOException {
        Preconditions.checkState(this.closed, "Cannot access metric unless the writer is closed.");
        if (this.simpleStatsExtractor != null) {
            return this.simpleStatsExtractor.extract(this.fileIO, this.path);
        }
        return this.simpleStatsCollector.extract();
    }
}

