/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.compression;

import java.io.Serializable;
import java.util.Objects;

public class CompressOptions
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String compress;
    private final int zstdLevel;

    public CompressOptions(String compress, int zstdLevel) {
        this.compress = compress;
        this.zstdLevel = zstdLevel;
    }

    public String compress() {
        return this.compress;
    }

    public int zstdLevel() {
        return this.zstdLevel;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompressOptions that = (CompressOptions)o;
        return this.zstdLevel == that.zstdLevel && Objects.equals(this.compress, that.compress);
    }

    public int hashCode() {
        return Objects.hash(this.compress, this.zstdLevel);
    }

    public String toString() {
        return "CompressOptions{compress='" + this.compress + '\'' + ", zstdLevel=" + this.zstdLevel + '}';
    }

    public static CompressOptions defaultOptions() {
        return new CompressOptions("zstd", 1);
    }
}

