/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.catalog.AbstractCatalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogDatabase;
import org.apache.flink.table.catalog.CatalogDatabaseImpl;
import org.apache.flink.table.catalog.CatalogFunction;
import org.apache.flink.table.catalog.CatalogMaterializedTable;
import org.apache.flink.table.catalog.CatalogPartition;
import org.apache.flink.table.catalog.CatalogPartitionImpl;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.CatalogView;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.IntervalFreshness;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.ResolvedCatalogBaseTable;
import org.apache.flink.table.catalog.ResolvedCatalogView;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.TableChange;
import org.apache.flink.table.catalog.WatermarkSpec;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.catalog.exceptions.DatabaseAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.DatabaseNotEmptyException;
import org.apache.flink.table.catalog.exceptions.DatabaseNotExistException;
import org.apache.flink.table.catalog.exceptions.FunctionNotExistException;
import org.apache.flink.table.catalog.exceptions.PartitionAlreadyExistsException;
import org.apache.flink.table.catalog.exceptions.PartitionNotExistException;
import org.apache.flink.table.catalog.exceptions.ProcedureNotExistException;
import org.apache.flink.table.catalog.exceptions.TableAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.TableNotExistException;
import org.apache.flink.table.catalog.exceptions.TableNotPartitionedException;
import org.apache.flink.table.catalog.stats.CatalogColumnStatistics;
import org.apache.flink.table.catalog.stats.CatalogTableStatistics;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.factories.Factory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.procedures.Procedure;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.table.utils.EncodingUtils;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.TableType;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.CatalogUtils;
import org.apache.paimon.catalog.Database;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.catalog.PropertyChange;
import org.apache.paimon.flink.DataCatalogTable;
import org.apache.paimon.flink.FlinkCatalogOptions;
import org.apache.paimon.flink.FlinkTableFactory;
import org.apache.paimon.flink.FormatCatalogTable;
import org.apache.paimon.flink.LogicalTypeConversion;
import org.apache.paimon.flink.SystemCatalogTable;
import org.apache.paimon.flink.log.LogStoreRegister;
import org.apache.paimon.flink.procedure.ProcedureUtil;
import org.apache.paimon.flink.utils.FlinkCatalogPropertiesUtil;
import org.apache.paimon.flink.utils.FlinkDescriptorProperties;
import org.apache.paimon.flink.utils.TableStatsUtil;
import org.apache.paimon.manifest.PartitionEntry;
import org.apache.paimon.options.Options;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.schema.SchemaChange;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.stats.Statistics;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.FormatTable;
import org.apache.paimon.table.Table;
import org.apache.paimon.table.sink.BatchTableCommit;
import org.apache.paimon.table.source.ReadBuilder;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeRoot;
import org.apache.paimon.types.MapType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.FileStorePathFactory;
import org.apache.paimon.utils.InternalRowPartitionComputer;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.StringUtils;
import org.apache.paimon.view.View;
import org.apache.paimon.view.ViewImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkCatalog
extends AbstractCatalog {
    public static final String DIALECT = "flink";
    private static final Logger LOG = LoggerFactory.getLogger(FlinkCatalog.class);
    private final ClassLoader classLoader;
    private final Catalog catalog;
    private final String name;
    private final boolean logStoreAutoRegister;
    private final Duration logStoreAutoRegisterTimeout;
    private final boolean disableCreateTableInDefaultDatabase;

    public FlinkCatalog(Catalog catalog, String name, String defaultDatabase, ClassLoader classLoader, Options options) {
        super(name, defaultDatabase);
        this.catalog = catalog;
        this.name = name;
        this.classLoader = classLoader;
        this.logStoreAutoRegister = options.get(FlinkCatalogOptions.LOG_SYSTEM_AUTO_REGISTER);
        this.logStoreAutoRegisterTimeout = options.get(FlinkCatalogOptions.REGISTER_TIMEOUT);
        this.disableCreateTableInDefaultDatabase = options.get(FlinkCatalogOptions.DISABLE_CREATE_TABLE_IN_DEFAULT_DB);
        if (!this.disableCreateTableInDefaultDatabase) {
            try {
                this.getDatabase(defaultDatabase);
            }
            catch (DatabaseNotExistException e) {
                try {
                    catalog.createDatabase(defaultDatabase, true);
                }
                catch (Catalog.DatabaseAlreadyExistException databaseAlreadyExistException) {
                    // empty catch block
                }
            }
        }
    }

    public Catalog catalog() {
        return this.catalog;
    }

    public Optional<Factory> getFactory() {
        return Optional.of(new FlinkTableFactory(this));
    }

    public List<String> listDatabases() throws CatalogException {
        return this.catalog.listDatabases();
    }

    public boolean databaseExists(String databaseName) throws CatalogException {
        try {
            this.catalog.getDatabase(databaseName);
            return true;
        }
        catch (Catalog.DatabaseNotExistException e) {
            return false;
        }
    }

    public CatalogDatabase getDatabase(String databaseName) throws CatalogException, DatabaseNotExistException {
        if (this.databaseExists(databaseName)) {
            return new CatalogDatabaseImpl(Collections.emptyMap(), null);
        }
        throw new DatabaseNotExistException(this.getName(), databaseName);
    }

    public void createDatabase(String name, CatalogDatabase database, boolean ignoreIfExists) throws DatabaseAlreadyExistException, CatalogException {
        Map<String, String> properties;
        if (database != null) {
            properties = new HashMap(database.getProperties());
            if (database.getDescription().isPresent() && !((String)database.getDescription().get()).equals("")) {
                properties.put("comment", (String)database.getDescription().get());
            }
        } else {
            properties = Collections.emptyMap();
        }
        try {
            this.catalog.createDatabase(name, ignoreIfExists, properties);
        }
        catch (Catalog.DatabaseAlreadyExistException e) {
            throw new DatabaseAlreadyExistException(this.getName(), e.database());
        }
    }

    public void dropDatabase(String name, boolean ignoreIfNotExists, boolean cascade) throws DatabaseNotEmptyException, DatabaseNotExistException, CatalogException {
        try {
            this.catalog.dropDatabase(name, ignoreIfNotExists, cascade);
        }
        catch (Catalog.DatabaseNotEmptyException e) {
            throw new DatabaseNotEmptyException(this.getName(), e.database());
        }
        catch (Catalog.DatabaseNotExistException e) {
            throw new DatabaseNotExistException(this.getName(), e.database());
        }
    }

    public List<String> listTables(String databaseName) throws DatabaseNotExistException, CatalogException {
        try {
            return this.catalog.listTables(databaseName);
        }
        catch (Catalog.DatabaseNotExistException e) {
            throw new DatabaseNotExistException(this.getName(), e.database());
        }
    }

    public CatalogBaseTable getTable(ObjectPath tablePath) throws TableNotExistException, CatalogException {
        return this.getTable(tablePath, null);
    }

    public CatalogBaseTable getTable(ObjectPath tablePath, long timestamp) throws TableNotExistException, CatalogException {
        return this.getTable(tablePath, (Long)timestamp);
    }

    private CatalogBaseTable getTable(ObjectPath tablePath, @Nullable Long timestamp) throws TableNotExistException {
        Table table;
        try {
            table = this.catalog.getTable(FlinkCatalog.toIdentifier(tablePath));
        }
        catch (Catalog.TableNotExistException e) {
            Optional<CatalogBaseTable> view = this.getView(tablePath, timestamp);
            if (view.isPresent()) {
                return view.get();
            }
            throw new TableNotExistException(this.getName(), tablePath);
        }
        if (table instanceof FormatTable) {
            if (timestamp != null) {
                throw new UnsupportedOperationException(String.format("Format table %s cannot support as of timestamp.", tablePath));
            }
            return new FormatCatalogTable((FormatTable)table);
        }
        if (timestamp != null) {
            Options options = new Options();
            options.set(CoreOptions.SCAN_TIMESTAMP_MILLIS, timestamp);
            table = table.copy(options.toMap());
        }
        if (table instanceof FileStoreTable) {
            return this.toCatalogTable(table);
        }
        return new SystemCatalogTable(table);
    }

    private Optional<CatalogBaseTable> getView(ObjectPath tablePath, @Nullable Long timestamp) {
        View view;
        try {
            view = this.catalog.getView(FlinkCatalog.toIdentifier(tablePath));
        }
        catch (Catalog.ViewNotExistException e) {
            return Optional.empty();
        }
        if (timestamp != null) {
            throw new UnsupportedOperationException(String.format("View %s does not support time travel.", tablePath));
        }
        org.apache.flink.table.api.Schema schema = org.apache.flink.table.api.Schema.newBuilder().fromRowDataType(TypeConversions.fromLogicalToDataType((LogicalType)LogicalTypeConversion.toLogicalType(view.rowType()))).build();
        String query = view.query(DIALECT);
        return Optional.of(CatalogView.of((org.apache.flink.table.api.Schema)schema, (String)view.comment().orElse(null), (String)query, (String)query, view.options()));
    }

    public boolean tableExists(ObjectPath tablePath) throws CatalogException {
        Identifier identifier = FlinkCatalog.toIdentifier(tablePath);
        try {
            this.catalog.getTable(identifier);
            return true;
        }
        catch (Catalog.TableNotExistException e) {
            try {
                this.catalog.getView(identifier);
                return true;
            }
            catch (Catalog.ViewNotExistException ex) {
                return false;
            }
        }
    }

    public void dropTable(ObjectPath tablePath, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException {
        Identifier identifier = FlinkCatalog.toIdentifier(tablePath);
        try {
            this.catalog.getView(identifier);
            try {
                this.catalog.dropView(identifier, ignoreIfNotExists);
                return;
            }
            catch (Catalog.ViewNotExistException e) {
                throw new RuntimeException("Unexpected exception.", e);
            }
        }
        catch (Catalog.ViewNotExistException e) {
            try {
                Table table = null;
                if (this.logStoreAutoRegister) {
                    try {
                        table = this.catalog.getTable(identifier);
                    }
                    catch (Catalog.TableNotExistException tableNotExistException) {
                        // empty catch block
                    }
                }
                this.catalog.dropTable(FlinkCatalog.toIdentifier(tablePath), ignoreIfNotExists);
                if (this.logStoreAutoRegister && table != null) {
                    LogStoreRegister.unRegisterLogSystem(identifier, table.options(), this.classLoader);
                }
            }
            catch (Catalog.TableNotExistException e2) {
                throw new TableNotExistException(this.getName(), tablePath);
            }
            return;
        }
    }

    public void createTable(ObjectPath tablePath, CatalogBaseTable table, boolean ignoreIfExists) throws TableAlreadyExistException, DatabaseNotExistException, CatalogException {
        if (Objects.equals(this.getDefaultDatabase(), tablePath.getDatabaseName()) && this.disableCreateTableInDefaultDatabase) {
            throw new UnsupportedOperationException("Creating table in default database is disabled, please specify a database name.");
        }
        if (table instanceof CatalogView) {
            this.createView(tablePath, (ResolvedCatalogView)table, ignoreIfExists);
            return;
        }
        Identifier identifier = FlinkCatalog.toIdentifier(tablePath);
        HashMap<String, String> options = new HashMap<String, String>(table.getOptions());
        if (table instanceof CatalogMaterializedTable) {
            FlinkCatalog.fillOptionsForMaterializedTable((CatalogMaterializedTable)table, options);
        }
        Schema paimonSchema = this.buildPaimonSchema(identifier, table, options);
        boolean unRegisterLogSystem = false;
        try {
            this.catalog.createTable(identifier, paimonSchema, ignoreIfExists);
        }
        catch (Catalog.TableAlreadyExistException e) {
            unRegisterLogSystem = true;
            throw new TableAlreadyExistException(this.getName(), tablePath);
        }
        catch (Catalog.DatabaseNotExistException e) {
            unRegisterLogSystem = true;
            throw new DatabaseNotExistException(this.getName(), e.database());
        }
        finally {
            if (this.logStoreAutoRegister && unRegisterLogSystem) {
                LogStoreRegister.unRegisterLogSystem(identifier, options, this.classLoader);
            }
        }
    }

    private void createView(ObjectPath tablePath, ResolvedCatalogView table, boolean ignoreIfExists) throws TableAlreadyExistException, DatabaseNotExistException {
        Identifier identifier = FlinkCatalog.toIdentifier(tablePath);
        RowType.Builder builder = RowType.builder();
        table.getResolvedSchema().getColumns().forEach(column -> builder.field(column.getName(), LogicalTypeConversion.toDataType(column.getDataType().getLogicalType()), column.getComment().orElse(null)));
        String query = table.getOriginalQuery();
        ViewImpl view = new ViewImpl(identifier, builder.build().getFields(), query, Collections.singletonMap(DIALECT, query), table.getComment(), table.getOptions());
        try {
            this.catalog.createView(identifier, view, ignoreIfExists);
        }
        catch (Catalog.ViewAlreadyExistException e) {
            throw new TableAlreadyExistException(this.getName(), tablePath);
        }
        catch (Catalog.DatabaseNotExistException e) {
            throw new DatabaseNotExistException(this.getName(), tablePath.getDatabaseName());
        }
    }

    private static void fillOptionsForMaterializedTable(CatalogMaterializedTable mt, Map<String, String> options) {
        Options mtOptions = new Options();
        mtOptions.set(CoreOptions.TYPE, TableType.MATERIALIZED_TABLE);
        mtOptions.set(CoreOptions.MATERIALIZED_TABLE_DEFINITION_QUERY, mt.getDefinitionQuery());
        mtOptions.set(CoreOptions.MATERIALIZED_TABLE_INTERVAL_FRESHNESS, mt.getDefinitionFreshness().getInterval());
        mtOptions.set(CoreOptions.MATERIALIZED_TABLE_INTERVAL_FRESHNESS_TIME_UNIT, CoreOptions.MaterializedTableIntervalFreshnessTimeUnit.valueOf(mt.getDefinitionFreshness().getTimeUnit().name()));
        mtOptions.set(CoreOptions.MATERIALIZED_TABLE_LOGICAL_REFRESH_MODE, CoreOptions.MaterializedTableRefreshMode.valueOf(mt.getLogicalRefreshMode().name()));
        mtOptions.set(CoreOptions.MATERIALIZED_TABLE_REFRESH_MODE, CoreOptions.MaterializedTableRefreshMode.valueOf(mt.getRefreshMode().name()));
        mtOptions.set(CoreOptions.MATERIALIZED_TABLE_REFRESH_STATUS, CoreOptions.MaterializedTableRefreshStatus.valueOf(mt.getRefreshStatus().name()));
        mt.getRefreshHandlerDescription().ifPresent(desc -> mtOptions.set(CoreOptions.MATERIALIZED_TABLE_REFRESH_HANDLER_DESCRIPTION, desc));
        byte[] serializedRefreshHandler = mt.getSerializedRefreshHandler();
        if (serializedRefreshHandler != null) {
            mtOptions.set(CoreOptions.MATERIALIZED_TABLE_REFRESH_HANDLER_BYTES, EncodingUtils.encodeBytesToBase64((byte[])serializedRefreshHandler));
        }
        options.putAll(mtOptions.toMap());
    }

    protected Schema buildPaimonSchema(Identifier identifier, CatalogBaseTable catalogTable, Map<String, String> options) {
        String connector = options.get(FactoryUtil.CONNECTOR.key());
        options.remove(FactoryUtil.CONNECTOR.key());
        if (!StringUtils.isNullOrWhitespaceOnly(connector) && !"paimon".equals(connector)) {
            throw new CatalogException("Paimon Catalog only supports paimon tables, but you specify  'connector'= '" + connector + "' when using Paimon Catalog\n You can create TEMPORARY table instead if you want to create the table of other connector.");
        }
        if (this.logStoreAutoRegister) {
            CatalogUtils.tableDefaultOptions(this.catalog.options()).forEach(options::putIfAbsent);
            options.put(FlinkCatalogOptions.REGISTER_TIMEOUT.key(), this.logStoreAutoRegisterTimeout.toString());
            LogStoreRegister.registerLogSystem(this.catalog, identifier, options, this.classLoader);
        }
        if (catalogTable instanceof CatalogTable) {
            return FlinkCatalog.fromCatalogTable((CatalogBaseTable)((CatalogTable)catalogTable).copy(options));
        }
        return FlinkCatalog.fromCatalogTable(((CatalogMaterializedTable)catalogTable).copy(options));
    }

    private List<SchemaChange> toSchemaChange(TableChange change, Map<String, Integer> oldTableNonPhysicalColumnIndex) {
        ArrayList<SchemaChange> schemaChanges = new ArrayList<SchemaChange>();
        if (change instanceof TableChange.AddColumn) {
            if (((TableChange.AddColumn)change).getColumn().isPhysical()) {
                TableChange.AddColumn add = (TableChange.AddColumn)change;
                String comment = add.getColumn().getComment().orElse(null);
                SchemaChange.Move move = this.getMove(add.getPosition(), add.getColumn().getName());
                schemaChanges.add(SchemaChange.addColumn(add.getColumn().getName(), LogicalTypeConversion.toDataType(add.getColumn().getDataType().getLogicalType()), comment, move));
            }
            return schemaChanges;
        }
        if (change instanceof TableChange.AddWatermark) {
            TableChange.AddWatermark add = (TableChange.AddWatermark)change;
            this.setWatermarkOptions(add.getWatermark(), schemaChanges);
            return schemaChanges;
        }
        if (change instanceof TableChange.DropColumn) {
            if (!oldTableNonPhysicalColumnIndex.containsKey(((TableChange.DropColumn)change).getColumnName())) {
                TableChange.DropColumn drop = (TableChange.DropColumn)change;
                schemaChanges.add(SchemaChange.dropColumn(drop.getColumnName()));
            }
            return schemaChanges;
        }
        if (change instanceof TableChange.DropWatermark) {
            String watermarkPrefix = FlinkCatalogPropertiesUtil.compoundKey("schema", "watermark", 0);
            schemaChanges.add(SchemaChange.removeOption(FlinkCatalogPropertiesUtil.compoundKey(watermarkPrefix, "rowtime")));
            schemaChanges.add(SchemaChange.removeOption(FlinkCatalogPropertiesUtil.compoundKey(watermarkPrefix, "strategy.expr")));
            schemaChanges.add(SchemaChange.removeOption(FlinkCatalogPropertiesUtil.compoundKey(watermarkPrefix, "strategy.data-type")));
            return schemaChanges;
        }
        if (change instanceof TableChange.ModifyColumnName) {
            if (!oldTableNonPhysicalColumnIndex.containsKey(((TableChange.ModifyColumnName)change).getOldColumnName())) {
                TableChange.ModifyColumnName modify = (TableChange.ModifyColumnName)change;
                schemaChanges.add(SchemaChange.renameColumn(modify.getOldColumnName(), modify.getNewColumnName()));
            }
            return schemaChanges;
        }
        if (change instanceof TableChange.ModifyPhysicalColumnType) {
            if (!oldTableNonPhysicalColumnIndex.containsKey(((TableChange.ModifyPhysicalColumnType)change).getOldColumn().getName())) {
                TableChange.ModifyPhysicalColumnType modify = (TableChange.ModifyPhysicalColumnType)change;
                this.generateNestedColumnUpdates(Collections.singletonList(modify.getOldColumn().getName()), LogicalTypeConversion.toDataType(modify.getOldColumn().getDataType().getLogicalType()), LogicalTypeConversion.toDataType(modify.getNewType().getLogicalType()), schemaChanges);
            }
            return schemaChanges;
        }
        if (change instanceof TableChange.ModifyColumnPosition) {
            if (!oldTableNonPhysicalColumnIndex.containsKey(((TableChange.ModifyColumnPosition)change).getOldColumn().getName())) {
                TableChange.ModifyColumnPosition modify = (TableChange.ModifyColumnPosition)change;
                SchemaChange.Move move = this.getMove(modify.getNewPosition(), modify.getNewColumn().getName());
                schemaChanges.add(SchemaChange.updateColumnPosition(move));
            }
            return schemaChanges;
        }
        if (change instanceof TableChange.ModifyColumnComment) {
            if (!oldTableNonPhysicalColumnIndex.containsKey(((TableChange.ModifyColumnComment)change).getOldColumn().getName())) {
                TableChange.ModifyColumnComment modify = (TableChange.ModifyColumnComment)change;
                schemaChanges.add(SchemaChange.updateColumnComment(modify.getNewColumn().getName(), modify.getNewComment()));
            }
            return schemaChanges;
        }
        if (change instanceof TableChange.ModifyWatermark) {
            TableChange.ModifyWatermark modify = (TableChange.ModifyWatermark)change;
            this.setWatermarkOptions(modify.getNewWatermark(), schemaChanges);
            return schemaChanges;
        }
        if (change instanceof TableChange.SetOption) {
            TableChange.SetOption setOption = (TableChange.SetOption)change;
            String key = setOption.getKey();
            String value = setOption.getValue();
            SchemaManager.checkAlterTablePath(key);
            if ("comment".equals(key)) {
                schemaChanges.add(SchemaChange.updateComment(value));
            } else {
                schemaChanges.add(SchemaChange.setOption(key, value));
            }
            return schemaChanges;
        }
        if (change instanceof TableChange.ResetOption) {
            TableChange.ResetOption resetOption = (TableChange.ResetOption)change;
            String key = resetOption.getKey();
            if ("comment".equals(key)) {
                schemaChanges.add(SchemaChange.updateComment(null));
            } else {
                schemaChanges.add(SchemaChange.removeOption(resetOption.getKey()));
            }
            return schemaChanges;
        }
        if (change instanceof TableChange.ModifyColumn) {
            if (oldTableNonPhysicalColumnIndex.containsKey(((TableChange.ModifyColumn)change).getOldColumn().getName()) && !(((TableChange.ModifyColumn)change).getNewColumn() instanceof Column.PhysicalColumn)) {
                return schemaChanges;
            }
            throw new UnsupportedOperationException("Change is not supported: " + change.getClass());
        }
        if (change instanceof TableChange.MaterializedTableChange && this.handleMaterializedTableChange(change, schemaChanges)) {
            return schemaChanges;
        }
        throw new UnsupportedOperationException("Change is not supported: " + change.getClass());
    }

    /*
     * WARNING - void declaration
     */
    private void generateNestedColumnUpdates(List<String> fieldNames, DataType oldType, DataType newType, List<SchemaChange> schemaChanges) {
        String joinedNames = String.join((CharSequence)".", fieldNames);
        if (oldType.getTypeRoot() == DataTypeRoot.ROW) {
            void var12_19;
            Preconditions.checkArgument(newType.getTypeRoot() == DataTypeRoot.ROW, "Column %s can only be updated to row type, and cannot be updated to %s type", new Object[]{joinedNames, newType.getTypeRoot()});
            RowType oldRowType = (RowType)oldType;
            RowType newRowType = (RowType)newType;
            HashMap<String, Integer> oldFieldOrders = new HashMap<String, Integer>();
            for (int i = 0; i < oldRowType.getFieldCount(); ++i) {
                oldFieldOrders.put(oldRowType.getFields().get(i).name(), i);
            }
            int lastIdx = -1;
            String lastFieldName = "";
            for (DataField dataField : newRowType.getFields()) {
                String name = dataField.name();
                if (!oldFieldOrders.containsKey(name)) continue;
                int idx = (Integer)oldFieldOrders.get(name);
                Preconditions.checkState(lastIdx < idx, "Order of existing fields in column %s must be kept the same. However, field %s and %s have changed their orders.", joinedNames, lastFieldName, name);
                lastIdx = idx;
                lastFieldName = name;
            }
            HashSet<String> newFieldNames = new HashSet<String>(newRowType.getFieldNames());
            for (String name : oldRowType.getFieldNames()) {
                if (newFieldNames.contains(name)) continue;
                ArrayList<String> dropColumnNames = new ArrayList<String>(fieldNames);
                dropColumnNames.add(name);
                schemaChanges.add(SchemaChange.dropColumn(dropColumnNames.toArray(new String[0])));
            }
            boolean bl = false;
            while (var12_19 < newRowType.getFieldCount()) {
                DataField field = newRowType.getFields().get((int)var12_19);
                String name = field.name();
                ArrayList<String> fullFieldNames = new ArrayList<String>(fieldNames);
                fullFieldNames.add(name);
                if (!oldFieldOrders.containsKey(name)) {
                    SchemaChange.Move move;
                    if (var12_19 == false) {
                        move = SchemaChange.Move.first(name);
                    } else {
                        String lastName = newRowType.getFields().get((int)(var12_19 - true)).name();
                        move = SchemaChange.Move.after(name, lastName);
                    }
                    schemaChanges.add(SchemaChange.addColumn(fullFieldNames.toArray(new String[0]), field.type(), field.description(), move));
                } else {
                    DataField oldField = oldRowType.getFields().get((Integer)oldFieldOrders.get(name));
                    if (!Objects.equals(oldField.description(), field.description())) {
                        schemaChanges.add(SchemaChange.updateColumnComment(fullFieldNames.toArray(new String[0]), field.description()));
                    }
                    this.generateNestedColumnUpdates(fullFieldNames, oldField.type(), field.type(), schemaChanges);
                }
                ++var12_19;
            }
        } else if (oldType.getTypeRoot() == DataTypeRoot.ARRAY) {
            Preconditions.checkArgument(newType.getTypeRoot() == DataTypeRoot.ARRAY, "Column %s can only be updated to array type, and cannot be updated to %s type", joinedNames, newType);
            ArrayList<String> fullFieldNames = new ArrayList<String>(fieldNames);
            fullFieldNames.add("element");
            this.generateNestedColumnUpdates(fullFieldNames, ((ArrayType)oldType).getElementType(), ((ArrayType)newType).getElementType(), schemaChanges);
        } else if (oldType.getTypeRoot() == DataTypeRoot.MAP) {
            Preconditions.checkArgument(newType.getTypeRoot() == DataTypeRoot.MAP, "Column %s can only be updated to map type, and cannot be updated to %s type", joinedNames, newType);
            MapType oldMapType = (MapType)oldType;
            MapType newMapType = (MapType)newType;
            Preconditions.checkArgument(oldMapType.getKeyType().equals(newMapType.getKeyType()), "Cannot update key type of column %s from %s type to %s type", joinedNames, oldMapType.getKeyType(), newMapType.getKeyType());
            ArrayList<String> fullFieldNames = new ArrayList<String>(fieldNames);
            fullFieldNames.add("value");
            this.generateNestedColumnUpdates(fullFieldNames, oldMapType.getValueType(), newMapType.getValueType(), schemaChanges);
        } else if (!oldType.equalsIgnoreNullable(newType)) {
            schemaChanges.add(SchemaChange.updateColumnType(fieldNames.toArray(new String[0]), newType, false));
        }
        if (oldType.isNullable() != newType.isNullable()) {
            schemaChanges.add(SchemaChange.updateColumnNullability(fieldNames.toArray(new String[0]), newType.isNullable()));
        }
    }

    protected boolean handleMaterializedTableChange(TableChange change, List<SchemaChange> schemaChanges) {
        if (change instanceof TableChange.ModifyRefreshStatus) {
            TableChange.ModifyRefreshStatus modifyRefreshStatus = (TableChange.ModifyRefreshStatus)change;
            CatalogMaterializedTable.RefreshStatus newRefreshStatus = modifyRefreshStatus.getRefreshStatus();
            schemaChanges.add(SchemaChange.setOption(CoreOptions.MATERIALIZED_TABLE_REFRESH_STATUS.key(), newRefreshStatus.name()));
            return true;
        }
        if (change instanceof TableChange.ModifyRefreshHandler) {
            TableChange.ModifyRefreshHandler modifyRefreshHandler = (TableChange.ModifyRefreshHandler)change;
            String newHandlerDesc = modifyRefreshHandler.getRefreshHandlerDesc();
            byte[] newHandlerBytes = modifyRefreshHandler.getRefreshHandlerBytes();
            schemaChanges.add(SchemaChange.setOption(CoreOptions.MATERIALIZED_TABLE_REFRESH_HANDLER_DESCRIPTION.key(), newHandlerDesc));
            schemaChanges.add(SchemaChange.setOption(CoreOptions.MATERIALIZED_TABLE_REFRESH_HANDLER_BYTES.key(), EncodingUtils.encodeBytesToBase64((byte[])newHandlerBytes)));
            return true;
        }
        return false;
    }

    public void alterTable(ObjectPath tablePath, CatalogBaseTable newTable, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException {
        if (ignoreIfNotExists && !this.tableExists(tablePath)) {
            return;
        }
        CatalogBaseTable table = this.getTable(tablePath);
        FlinkCatalog.validateAlterTable(table, newTable);
        ArrayList<SchemaChange> changes = new ArrayList<SchemaChange>();
        Map oldProperties = table.getOptions();
        for (Map.Entry entry : newTable.getOptions().entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (Objects.equals(value, oldProperties.get(key))) continue;
            if (CoreOptions.PATH.key().equalsIgnoreCase(key)) {
                throw new IllegalArgumentException("Illegal table path in table options: " + value);
            }
            changes.add(SchemaChange.setOption(key, value));
        }
        oldProperties.keySet().forEach(k -> {
            if (!newTable.getOptions().containsKey(k)) {
                changes.add(SchemaChange.removeOption(k));
            }
        });
        try {
            this.catalog.alterTable(FlinkCatalog.toIdentifier(tablePath), changes, ignoreIfNotExists);
        }
        catch (Catalog.TableNotExistException e) {
            throw new TableNotExistException(this.getName(), tablePath);
        }
        catch (Catalog.ColumnAlreadyExistException | Catalog.ColumnNotExistException e) {
            throw new CatalogException((Throwable)e);
        }
    }

    public void alterTable(ObjectPath tablePath, CatalogBaseTable newTable, List<TableChange> tableChanges, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException {
        Table table;
        if (ignoreIfNotExists && !this.tableExists(tablePath)) {
            return;
        }
        try {
            table = this.catalog.getTable(FlinkCatalog.toIdentifier(tablePath));
        }
        catch (Catalog.TableNotExistException e) {
            throw new TableNotExistException(this.getName(), tablePath);
        }
        Preconditions.checkArgument(table instanceof FileStoreTable, "Only support alter data table, but is: " + table.getClass());
        FlinkCatalog.validateAlterTable(this.toCatalogTable(table), newTable);
        Map<String, Integer> oldTableNonPhysicalColumnIndex = FlinkCatalogPropertiesUtil.nonPhysicalColumns(table.options(), table.rowType().getFieldNames());
        ArrayList<SchemaChange> changes = new ArrayList<SchemaChange>();
        Map<String, String> schemaOptions = FlinkCatalogPropertiesUtil.serializeNonPhysicalNewColumns(((ResolvedCatalogBaseTable)newTable).getResolvedSchema());
        table.options().forEach((k, v) -> {
            if (FlinkCatalogPropertiesUtil.isNonPhysicalColumnKey(k) && !schemaOptions.containsKey(k)) {
                changes.add(SchemaChange.removeOption(k));
            }
        });
        schemaOptions.forEach((k, v) -> {
            if (!table.options().containsKey(k) || !table.options().get(k).equals(v)) {
                changes.add(SchemaChange.setOption(k, v));
            }
        });
        if (null != tableChanges) {
            List schemaChanges = tableChanges.stream().flatMap(tableChange -> this.toSchemaChange((TableChange)tableChange, oldTableNonPhysicalColumnIndex).stream()).collect(Collectors.toList());
            changes.addAll(schemaChanges);
        }
        try {
            this.catalog.alterTable(FlinkCatalog.toIdentifier(tablePath), changes, ignoreIfNotExists);
        }
        catch (Catalog.ColumnAlreadyExistException | Catalog.ColumnNotExistException | Catalog.TableNotExistException e) {
            throw new CatalogException((Throwable)e);
        }
    }

    private SchemaChange.Move getMove(TableChange.ColumnPosition columnPosition, String fieldName) {
        SchemaChange.Move move = null;
        if (columnPosition instanceof TableChange.First) {
            move = SchemaChange.Move.first(fieldName);
        } else if (columnPosition instanceof TableChange.After) {
            move = SchemaChange.Move.after(fieldName, ((TableChange.After)columnPosition).column());
        }
        return move;
    }

    private String getWatermarkKeyPrefix() {
        return FlinkCatalogPropertiesUtil.compoundKey("schema", "watermark", 0);
    }

    private String getWatermarkRowTimeKey(String watermarkPrefix) {
        return FlinkCatalogPropertiesUtil.compoundKey(watermarkPrefix, "rowtime");
    }

    private String getWatermarkExprKey(String watermarkPrefix) {
        return FlinkCatalogPropertiesUtil.compoundKey(watermarkPrefix, "strategy.expr");
    }

    private String getWatermarkExprDataTypeKey(String watermarkPrefix) {
        return FlinkCatalogPropertiesUtil.compoundKey(watermarkPrefix, "strategy.data-type");
    }

    private void setWatermarkOptions(WatermarkSpec wms, List<SchemaChange> schemaChanges) {
        String watermarkPrefix = this.getWatermarkKeyPrefix();
        schemaChanges.add(SchemaChange.setOption(this.getWatermarkRowTimeKey(watermarkPrefix), wms.getRowtimeAttribute()));
        schemaChanges.add(SchemaChange.setOption(this.getWatermarkExprKey(watermarkPrefix), wms.getWatermarkExpression().asSerializableString()));
        schemaChanges.add(SchemaChange.setOption(this.getWatermarkExprDataTypeKey(watermarkPrefix), wms.getWatermarkExpression().getOutputDataType().getLogicalType().asSerializableString()));
    }

    private static void validateAlterTable(CatalogBaseTable ct1, CatalogBaseTable ct2) {
        if (ct1 instanceof SystemCatalogTable) {
            throw new UnsupportedOperationException("Can't alter system table.");
        }
        boolean table1IsMaterialized = ct1 instanceof CatalogMaterializedTable;
        boolean table2IsMaterialized = ct2 instanceof CatalogMaterializedTable;
        if (!(!table1IsMaterialized && !table2IsMaterialized || table1IsMaterialized && table2IsMaterialized)) {
            throw new UnsupportedOperationException("Convert a non-materialized table to materialized table or vice versa is not allowed.");
        }
        if (!table1IsMaterialized) {
            org.apache.flink.table.api.Schema ts1 = ct1.getUnresolvedSchema();
            org.apache.flink.table.api.Schema ts2 = ct2.getUnresolvedSchema();
            boolean pkEquality = false;
            if (ts1.getPrimaryKey().isPresent() && ts2.getPrimaryKey().isPresent()) {
                pkEquality = Objects.equals(((Schema.UnresolvedPrimaryKey)ts1.getPrimaryKey().get()).getConstraintName(), ((Schema.UnresolvedPrimaryKey)ts2.getPrimaryKey().get()).getConstraintName()) && Objects.equals(((Schema.UnresolvedPrimaryKey)ts1.getPrimaryKey().get()).getColumnNames(), ((Schema.UnresolvedPrimaryKey)ts2.getPrimaryKey().get()).getColumnNames());
            } else if (!ts1.getPrimaryKey().isPresent() && !ts2.getPrimaryKey().isPresent()) {
                pkEquality = true;
            }
            if (!pkEquality) {
                throw new UnsupportedOperationException("Altering primary key is not supported yet.");
            }
        }
        if (!FlinkCatalog.getPartitionKeys(ct1).equals(FlinkCatalog.getPartitionKeys(ct2))) {
            throw new UnsupportedOperationException("Altering partition keys is not supported yet.");
        }
    }

    private static List<String> getPartitionKeys(CatalogBaseTable table) {
        if (table instanceof CatalogTable) {
            return ((CatalogTable)table).getPartitionKeys();
        }
        if (table instanceof CatalogMaterializedTable) {
            return ((CatalogMaterializedTable)table).getPartitionKeys();
        }
        throw new UnsupportedOperationException("Only support CatalogTable and CatalogMaterializedTable, but is: " + table.getClass());
    }

    public final void open() throws CatalogException {
    }

    public final void close() throws CatalogException {
        try {
            this.catalog.close();
        }
        catch (Exception e) {
            throw new CatalogException("Failed to close catalog " + this.catalog.toString(), (Throwable)e);
        }
    }

    private CatalogBaseTable toCatalogTable(Table table) {
        HashMap<String, String> newOptions = new HashMap<String, String>(table.options());
        Schema.Builder builder = org.apache.flink.table.api.Schema.newBuilder();
        HashMap<String, String> nonPhysicalColumnComments = new HashMap<String, String>();
        List physicalRowFields = LogicalTypeConversion.toLogicalType(table.rowType()).getFields();
        List<String> physicalColumns = table.rowType().getFieldNames();
        int columnCount = physicalRowFields.size() + FlinkCatalogPropertiesUtil.nonPhysicalColumnsCount(newOptions, physicalColumns);
        int physicalColumnIndex = 0;
        for (int i = 0; i < columnCount; ++i) {
            String optionalName = (String)newOptions.get(FlinkCatalogPropertiesUtil.compoundKey("schema", i, "name"));
            if (optionalName == null || physicalColumns.contains(optionalName)) {
                RowType.RowField field = (RowType.RowField)physicalRowFields.get(physicalColumnIndex++);
                builder.column(field.getName(), (AbstractDataType)TypeConversions.fromLogicalToDataType((LogicalType)field.getType()));
                continue;
            }
            FlinkCatalogPropertiesUtil.deserializeNonPhysicalColumn(newOptions, i, builder);
            if (!newOptions.containsKey(FlinkCatalogPropertiesUtil.compoundKey("schema", i, "comment"))) continue;
            nonPhysicalColumnComments.put(optionalName, (String)newOptions.get(FlinkCatalogPropertiesUtil.compoundKey("schema", i, "comment")));
            newOptions.remove(FlinkCatalogPropertiesUtil.compoundKey("schema", i, "comment"));
        }
        if (newOptions.keySet().stream().anyMatch(key -> key.startsWith(FlinkCatalogPropertiesUtil.compoundKey("schema", "watermark")))) {
            FlinkCatalogPropertiesUtil.deserializeWatermarkSpec(newOptions, builder);
        }
        if (table.primaryKeys().size() > 0) {
            builder.primaryKey(table.primaryKeys());
        }
        org.apache.flink.table.api.Schema schema = builder.build();
        FlinkDescriptorProperties.removeSchemaKeys("schema", schema, newOptions);
        Options options = Options.fromMap(newOptions);
        if (TableType.MATERIALIZED_TABLE == options.get(CoreOptions.TYPE)) {
            return this.buildMaterializedTable(table, newOptions, schema, options);
        }
        return new DataCatalogTable(table, schema, table.partitionKeys(), newOptions, table.comment().orElse(""), nonPhysicalColumnComments);
    }

    private CatalogMaterializedTable buildMaterializedTable(Table table, Map<String, String> newOptions, org.apache.flink.table.api.Schema schema, Options options) {
        String definitionQuery = options.get(CoreOptions.MATERIALIZED_TABLE_DEFINITION_QUERY);
        IntervalFreshness freshness = IntervalFreshness.of((String)options.get(CoreOptions.MATERIALIZED_TABLE_INTERVAL_FRESHNESS), (IntervalFreshness.TimeUnit)IntervalFreshness.TimeUnit.valueOf((String)options.get(CoreOptions.MATERIALIZED_TABLE_INTERVAL_FRESHNESS_TIME_UNIT).name()));
        CatalogMaterializedTable.LogicalRefreshMode logicalRefreshMode = CatalogMaterializedTable.LogicalRefreshMode.valueOf(options.get(CoreOptions.MATERIALIZED_TABLE_LOGICAL_REFRESH_MODE).name());
        CatalogMaterializedTable.RefreshMode refreshMode = CatalogMaterializedTable.RefreshMode.valueOf(options.get(CoreOptions.MATERIALIZED_TABLE_REFRESH_MODE).name());
        CatalogMaterializedTable.RefreshStatus refreshStatus = CatalogMaterializedTable.RefreshStatus.valueOf(options.get(CoreOptions.MATERIALIZED_TABLE_REFRESH_STATUS).name());
        String refreshHandlerDescription = options.get(CoreOptions.MATERIALIZED_TABLE_REFRESH_HANDLER_DESCRIPTION);
        byte[] serializedRefreshHandler = this.decodeRefreshHandlerBytes(options.get(CoreOptions.MATERIALIZED_TABLE_REFRESH_HANDLER_BYTES));
        this.allMaterializedTableAttributes().forEach(newOptions::remove);
        return CatalogMaterializedTable.newBuilder().schema(schema).comment(table.comment().orElse("")).partitionKeys(table.partitionKeys()).options(newOptions).definitionQuery(definitionQuery).freshness(freshness).logicalRefreshMode(logicalRefreshMode).refreshMode(refreshMode).refreshStatus(refreshStatus).refreshHandlerDescription(refreshHandlerDescription).serializedRefreshHandler(serializedRefreshHandler).build();
    }

    private byte[] decodeRefreshHandlerBytes(String refreshHandlerBytes) {
        return org.apache.flink.util.StringUtils.isNullOrWhitespaceOnly((String)refreshHandlerBytes) ? null : EncodingUtils.decodeBase64ToBytes((String)refreshHandlerBytes);
    }

    public static Schema fromCatalogTable(CatalogBaseTable catalogTable) {
        ResolvedSchema schema = ((ResolvedCatalogBaseTable)catalogTable).getResolvedSchema();
        org.apache.flink.table.types.logical.RowType rowType = (org.apache.flink.table.types.logical.RowType)schema.toPhysicalRowDataType().getLogicalType();
        HashMap<String, String> options = new HashMap<String, String>(catalogTable.getOptions());
        options.putAll(FlinkCatalog.columnOptions(schema));
        Schema.Builder schemaBuilder = Schema.newBuilder().comment(catalogTable.getComment()).options(options).primaryKey(schema.getPrimaryKey().map(pk -> pk.getColumns()).orElse(Collections.emptyList())).partitionKeys(FlinkCatalog.getPartitionKeys(catalogTable));
        Map<String, String> columnComments = FlinkCatalog.getColumnComments(catalogTable);
        rowType.getFields().forEach(field -> schemaBuilder.column(field.getName(), LogicalTypeConversion.toDataType(field.getType()), (String)columnComments.get(field.getName())));
        return schemaBuilder.build();
    }

    private static Map<String, String> getColumnComments(CatalogBaseTable catalogTable) {
        return catalogTable.getUnresolvedSchema().getColumns().stream().filter(c -> c.getComment().isPresent()).collect(Collectors.toMap(Schema.UnresolvedColumn::getName, c -> (String)c.getComment().get()));
    }

    private static Map<String, String> columnOptions(ResolvedSchema schema) {
        HashMap<String, String> columnOptions = new HashMap<String, String>(FlinkCatalogPropertiesUtil.serializeNonPhysicalNewColumns(schema));
        List watermarkSpecs = schema.getWatermarkSpecs();
        if (!watermarkSpecs.isEmpty()) {
            Preconditions.checkArgument(watermarkSpecs.size() == 1);
            columnOptions.putAll(FlinkCatalogPropertiesUtil.serializeNewWatermarkSpec((WatermarkSpec)watermarkSpecs.get(0)));
        }
        return columnOptions;
    }

    public static Identifier toIdentifier(ObjectPath path) {
        return new Identifier(path.getDatabaseName(), path.getObjectName());
    }

    public final void alterDatabase(String name, CatalogDatabase newDatabase, boolean ignoreIfNotExists) throws CatalogException, DatabaseNotExistException {
        block2: {
            try {
                Database oldDatabase = this.catalog.getDatabase(name);
                List<PropertyChange> changes = FlinkCatalog.getPropertyChanges(oldDatabase.options(), newDatabase.getProperties());
                FlinkCatalog.getPropertyChangeFromComment(oldDatabase.comment(), newDatabase.getDescription()).ifPresent(changes::add);
                this.catalog.alterDatabase(name, changes, ignoreIfNotExists);
            }
            catch (Catalog.DatabaseNotExistException e) {
                if (ignoreIfNotExists) break block2;
                throw new DatabaseNotExistException(this.getName(), e.database());
            }
        }
    }

    public final void renameTable(ObjectPath tablePath, String newTableName, boolean ignoreIfNotExists) throws CatalogException, TableNotExistException, TableAlreadyExistException {
        ObjectPath toTable = new ObjectPath(tablePath.getDatabaseName(), newTableName);
        try {
            this.catalog.renameTable(FlinkCatalog.toIdentifier(tablePath), FlinkCatalog.toIdentifier(toTable), ignoreIfNotExists);
        }
        catch (Catalog.TableNotExistException e) {
            try {
                this.catalog.renameView(FlinkCatalog.toIdentifier(tablePath), FlinkCatalog.toIdentifier(toTable), ignoreIfNotExists);
            }
            catch (Catalog.ViewNotExistException ex) {
                throw new TableNotExistException(this.getName(), tablePath);
            }
            catch (Catalog.ViewAlreadyExistException ex) {
                throw new TableAlreadyExistException(this.getName(), toTable);
            }
        }
        catch (Catalog.TableAlreadyExistException e) {
            throw new TableAlreadyExistException(this.getName(), toTable);
        }
    }

    public final List<String> listViews(String databaseName) throws DatabaseNotExistException, CatalogException {
        try {
            return this.catalog.listViews(databaseName);
        }
        catch (Catalog.DatabaseNotExistException e) {
            throw new DatabaseNotExistException(this.getName(), databaseName);
        }
    }

    public final List<CatalogPartitionSpec> listPartitions(ObjectPath tablePath) throws TableNotExistException, TableNotPartitionedException, CatalogException {
        if (this.isCalledFromFlinkRecomputeStatisticsProgram()) {
            LOG.info("Skipping listPartitions method due to detection of FlinkRecomputeStatisticsProgram call.");
            return Collections.emptyList();
        }
        return this.getPartitionSpecs(tablePath, null);
    }

    @VisibleForTesting
    static List<PropertyChange> getPropertyChanges(Map<String, String> oldOptions, Map<String, String> newOptions) {
        ArrayList<PropertyChange> changes = new ArrayList<PropertyChange>();
        newOptions.forEach((k, v) -> {
            if (!oldOptions.containsKey(k) || !((String)oldOptions.get(k)).equals(v)) {
                changes.add(PropertyChange.setProperty(k, v));
            }
        });
        oldOptions.keySet().forEach(k -> {
            if (!newOptions.containsKey(k)) {
                changes.add(PropertyChange.removeProperty(k));
            }
        });
        return changes;
    }

    @VisibleForTesting
    static Optional<PropertyChange> getPropertyChangeFromComment(Optional<String> oldComment, Optional<String> newComment) {
        if (newComment.isPresent() && !oldComment.equals(newComment)) {
            return Optional.of(PropertyChange.setProperty("comment", newComment.get()));
        }
        return Optional.empty();
    }

    private Table getPaimonTable(ObjectPath tablePath) throws TableNotExistException {
        try {
            Identifier identifier = FlinkCatalog.toIdentifier(tablePath);
            return this.catalog.getTable(identifier);
        }
        catch (Catalog.TableNotExistException e) {
            throw new TableNotExistException(this.getName(), tablePath);
        }
    }

    private List<PartitionEntry> getPartitionEntries(Table table, ObjectPath tablePath, @Nullable CatalogPartitionSpec partitionSpec) throws TableNotPartitionedException {
        if (table.partitionKeys() == null || table.partitionKeys().size() == 0) {
            throw new TableNotPartitionedException(this.getName(), tablePath);
        }
        ReadBuilder readBuilder = table.newReadBuilder();
        if (partitionSpec != null && partitionSpec.getPartitionSpec() != null) {
            readBuilder.withPartitionFilter(partitionSpec.getPartitionSpec());
        }
        return readBuilder.newScan().listPartitionEntries();
    }

    private List<CatalogPartitionSpec> getPartitionSpecs(ObjectPath tablePath, @Nullable CatalogPartitionSpec partitionSpec) throws CatalogException, TableNotPartitionedException, TableNotExistException {
        FileStoreTable table = (FileStoreTable)this.getPaimonTable(tablePath);
        List<PartitionEntry> partitionEntries = this.getPartitionEntries(table, tablePath, partitionSpec);
        RowType partitionRowType = table.schema().logicalPartitionType();
        CoreOptions options = new CoreOptions(table.options());
        InternalRowPartitionComputer partitionComputer = FileStorePathFactory.getPartitionComputer(partitionRowType, options.partitionDefaultName(), options.legacyPartitionName());
        return partitionEntries.stream().map(e -> {
            LinkedHashMap<String, String> partValues = partitionComputer.generatePartValues(Preconditions.checkNotNull(e.partition(), "Partition row data is null. This is unexpected."));
            return new CatalogPartitionSpec(partValues);
        }).collect(Collectors.toList());
    }

    public final List<CatalogPartitionSpec> listPartitions(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws TableNotExistException, TableNotPartitionedException, CatalogException {
        return this.getPartitionSpecs(tablePath, partitionSpec);
    }

    public final List<CatalogPartitionSpec> listPartitionsByFilter(ObjectPath tablePath, List<Expression> filters) throws CatalogException {
        return Collections.emptyList();
    }

    public CatalogPartition getPartition(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws PartitionNotExistException, CatalogException {
        Preconditions.checkNotNull(partitionSpec, "partition spec shouldn't be null");
        try {
            List<PartitionEntry> partitionEntries = this.getPartitionEntries(this.getPaimonTable(tablePath), tablePath, partitionSpec);
            if (partitionEntries.isEmpty()) {
                throw new PartitionNotExistException(this.getName(), tablePath, partitionSpec);
            }
            PartitionEntry partitionEntry = partitionEntries.get(0);
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("numRows", String.valueOf(partitionEntry.recordCount()));
            properties.put("lastUpdateTime", String.valueOf(partitionEntry.lastFileCreationTime()));
            properties.put("numFiles", String.valueOf(partitionEntry.fileCount()));
            properties.put("totalSize", String.valueOf(partitionEntry.fileSizeInBytes()));
            return new CatalogPartitionImpl(properties, "");
        }
        catch (TableNotExistException | TableNotPartitionedException e) {
            throw new PartitionNotExistException(this.getName(), tablePath, partitionSpec);
        }
    }

    public final boolean partitionExists(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws CatalogException {
        try {
            List<CatalogPartitionSpec> partitionSpecs = this.getPartitionSpecs(tablePath, partitionSpec);
            return partitionSpecs.size() > 0;
        }
        catch (TableNotExistException | TableNotPartitionedException e) {
            throw new CatalogException(e);
        }
    }

    public final void createPartition(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, CatalogPartition partition, boolean ignoreIfExists) throws CatalogException, PartitionAlreadyExistsException {
        if (this.partitionExists(tablePath, partitionSpec) && !ignoreIfExists) {
            throw new PartitionAlreadyExistsException(this.getName(), tablePath, partitionSpec);
        }
        try {
            Identifier identifier = FlinkCatalog.toIdentifier(tablePath);
            this.catalog.createPartitions(identifier, Collections.singletonList(partitionSpec.getPartitionSpec()));
        }
        catch (Catalog.TableNotExistException e) {
            throw new CatalogException((Throwable)e);
        }
    }

    public final void dropPartition(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, boolean ignoreIfNotExists) throws PartitionNotExistException, CatalogException {
        if (!this.partitionExists(tablePath, partitionSpec) && !ignoreIfNotExists) {
            throw new PartitionNotExistException(this.getName(), tablePath, partitionSpec);
        }
        try {
            Identifier identifier = FlinkCatalog.toIdentifier(tablePath);
            List<Map<String, String>> partitions = Collections.singletonList(partitionSpec.getPartitionSpec());
            this.catalog.dropPartitions(identifier, partitions);
        }
        catch (Catalog.TableNotExistException e) {
            throw new CatalogException((Throwable)e);
        }
    }

    public final void alterPartition(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, CatalogPartition newPartition, boolean ignoreIfNotExists) throws CatalogException {
        throw new UnsupportedOperationException();
    }

    public final List<String> listFunctions(String dbName) throws CatalogException {
        return Collections.emptyList();
    }

    public final CatalogFunction getFunction(ObjectPath functionPath) throws FunctionNotExistException, CatalogException {
        throw new FunctionNotExistException(this.getName(), functionPath);
    }

    public final boolean functionExists(ObjectPath functionPath) throws CatalogException {
        return false;
    }

    public final void createFunction(ObjectPath functionPath, CatalogFunction function, boolean ignoreIfExists) throws CatalogException {
        throw new UnsupportedOperationException("Create function is not supported, maybe you can use 'CREATE TEMPORARY FUNCTION' instead.");
    }

    public final void alterFunction(ObjectPath functionPath, CatalogFunction newFunction, boolean ignoreIfNotExists) throws CatalogException {
        throw new UnsupportedOperationException();
    }

    public final void dropFunction(ObjectPath functionPath, boolean ignoreIfNotExists) throws CatalogException {
        throw new UnsupportedOperationException();
    }

    public final CatalogTableStatistics getTableStatistics(ObjectPath tablePath) throws CatalogException {
        return CatalogTableStatistics.UNKNOWN;
    }

    public final CatalogColumnStatistics getTableColumnStatistics(ObjectPath tablePath) throws CatalogException {
        return CatalogColumnStatistics.UNKNOWN;
    }

    public final CatalogTableStatistics getPartitionStatistics(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws CatalogException {
        return CatalogTableStatistics.UNKNOWN;
    }

    public final CatalogColumnStatistics getPartitionColumnStatistics(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws CatalogException {
        return CatalogColumnStatistics.UNKNOWN;
    }

    public final void alterTableStatistics(ObjectPath tablePath, CatalogTableStatistics tableStatistics, boolean ignoreIfNotExists) throws CatalogException, TableNotExistException {
        this.alterTableStatisticsInternal(tablePath, t -> TableStatsUtil.createTableStats(t, tableStatistics), ignoreIfNotExists);
    }

    public final void alterTableColumnStatistics(ObjectPath tablePath, CatalogColumnStatistics columnStatistics, boolean ignoreIfNotExists) throws CatalogException, TableNotExistException {
        this.alterTableStatisticsInternal(tablePath, t -> TableStatsUtil.createTableColumnStats(t, columnStatistics), ignoreIfNotExists);
    }

    private void alterTableStatisticsInternal(ObjectPath tablePath, Function<FileStoreTable, Statistics> statistics, boolean ignoreIfNotExists) throws TableNotExistException {
        block17: {
            try {
                Table table = this.catalog.getTable(FlinkCatalog.toIdentifier(tablePath));
                Preconditions.checkArgument(table instanceof FileStoreTable, "Now only support analyze FileStoreTable.");
                if (!table.latestSnapshot().isPresent()) {
                    LOG.info("Skipping analyze table because the snapshot is null.");
                    return;
                }
                Statistics tableStats = statistics.apply((FileStoreTable)table);
                if (tableStats == null) break block17;
                try (BatchTableCommit commit = table.newBatchWriteBuilder().newCommit();){
                    commit.updateStatistics(tableStats);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            catch (Catalog.TableNotExistException e) {
                if (ignoreIfNotExists) break block17;
                throw new TableNotExistException(this.getName(), tablePath);
            }
        }
    }

    public final void alterPartitionStatistics(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, CatalogTableStatistics partitionStatistics, boolean ignoreIfNotExists) throws CatalogException {
        throw new UnsupportedOperationException();
    }

    public final void alterPartitionColumnStatistics(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, CatalogColumnStatistics columnStatistics, boolean ignoreIfNotExists) throws CatalogException {
        throw new UnsupportedOperationException();
    }

    public List<String> listProcedures(String dbName) throws DatabaseNotExistException, CatalogException {
        if (!this.databaseExists(dbName)) {
            throw new DatabaseNotExistException(this.name, dbName);
        }
        return ProcedureUtil.listProcedures();
    }

    public Procedure getProcedure(ObjectPath procedurePath) throws ProcedureNotExistException, CatalogException {
        return ProcedureUtil.getProcedure(this.catalog, procedurePath).orElseThrow(() -> new ProcedureNotExistException(this.name, procedurePath));
    }

    private boolean isCalledFromFlinkRecomputeStatisticsProgram() {
        StackTraceElement[] stackTrace;
        for (StackTraceElement stackTraceElement : stackTrace = Thread.currentThread().getStackTrace()) {
            if (!stackTraceElement.getClassName().contains("FlinkRecomputeStatisticsProgram")) continue;
            return true;
        }
        return false;
    }

    private List<String> allMaterializedTableAttributes() {
        return Arrays.asList(CoreOptions.MATERIALIZED_TABLE_DEFINITION_QUERY.key(), CoreOptions.MATERIALIZED_TABLE_INTERVAL_FRESHNESS.key(), CoreOptions.MATERIALIZED_TABLE_INTERVAL_FRESHNESS_TIME_UNIT.key(), CoreOptions.MATERIALIZED_TABLE_REFRESH_MODE.key(), CoreOptions.MATERIALIZED_TABLE_LOGICAL_REFRESH_MODE.key(), CoreOptions.MATERIALIZED_TABLE_REFRESH_STATUS.key(), CoreOptions.MATERIALIZED_TABLE_REFRESH_HANDLER_DESCRIPTION.key(), CoreOptions.MATERIALIZED_TABLE_REFRESH_HANDLER_BYTES.key());
    }
}

