/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.paimon.flink.action.cdc.ComputedColumn;
import org.apache.paimon.flink.action.cdc.Expression;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.utils.Preconditions;

public class ComputedColumnUtils {
    public static List<ComputedColumn> buildComputedColumns(List<String> computedColumnArgs, List<DataField> physicFields) {
        return ComputedColumnUtils.buildComputedColumns(computedColumnArgs, physicFields, true);
    }

    public static List<ComputedColumn> buildComputedColumns(List<String> computedColumnArgs, List<DataField> physicFields, boolean caseSensitive) {
        Map<String, DataType> typeMapping = physicFields.stream().collect(Collectors.toMap(DataField::name, DataField::type, (v1, v2) -> v2));
        ArrayList<ComputedColumn> computedColumns = new ArrayList<ComputedColumn>();
        for (String columnArg : computedColumnArgs) {
            String[] kv = columnArg.split("=");
            if (kv.length != 2) {
                throw new IllegalArgumentException(String.format("Invalid computed column argument: %s. Please use format 'column-name=expr-name(args, ...)'.", columnArg));
            }
            String columnName = kv[0].trim();
            String expression = kv[1].trim();
            int left = expression.indexOf(40);
            int right = expression.indexOf(41);
            Preconditions.checkArgument(left > 0 && right > left, String.format("Invalid expression: %s. Please use format 'expr-name(args, ...)'.", expression));
            String exprName = expression.substring(0, left);
            String[] args2 = expression.substring(left + 1, right).split(",");
            Preconditions.checkArgument(args2.length >= 1, "Computed column needs at least one argument.");
            computedColumns.add(new ComputedColumn(columnName, Expression.create(typeMapping, caseSensitive, exprName, args2)));
        }
        return computedColumns;
    }
}

