/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.utils;

import org.apache.flink.core.memory.ManagedMemoryUseCase;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.paimon.options.MemorySize;

public class ManagedMemoryUtils {
    public static void declareManagedMemory(DataStream<?> dataStream, MemorySize memorySize) {
        dataStream.getTransformation().declareManagedMemoryUseCaseAtOperatorScope(ManagedMemoryUseCase.OPERATOR, memorySize.getMebiBytes());
    }

    public static long computeManagedMemory(AbstractStreamOperator<?> operator) {
        Environment environment = operator.getContainingTask().getEnvironment();
        return environment.getMemoryManager().computeMemorySize(operator.getOperatorConfig().getManagedMemoryFractionOperatorUseCaseOfSlot(ManagedMemoryUseCase.OPERATOR, environment.getTaskManagerInfo().getConfiguration(), environment.getUserCodeClassLoader().asClassLoader()));
    }
}

