/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.parquet.reader;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.PrimitiveIterator;

public class ParquetReadState {
    private static final RowRange MAX_ROW_RANGE = new RowRange(Long.MIN_VALUE, Long.MAX_VALUE);
    private static final RowRange END_ROW_RANGE = new RowRange(Long.MAX_VALUE, Long.MIN_VALUE);
    private final Iterator<RowRange> rowRanges;
    private RowRange currentRange;
    long rowId;
    int valuesToReadInPage;
    int rowsToReadInBatch;

    public ParquetReadState(PrimitiveIterator.OfLong rowIndexes) {
        this.rowRanges = this.constructRanges(rowIndexes);
        this.nextRange();
    }

    private Iterator<RowRange> constructRanges(PrimitiveIterator.OfLong rowIndexes) {
        if (rowIndexes == null) {
            return null;
        }
        ArrayList<RowRange> rowRanges = new ArrayList<RowRange>();
        long currentStart = Long.MIN_VALUE;
        long previous = Long.MIN_VALUE;
        while (rowIndexes.hasNext()) {
            long idx = rowIndexes.nextLong();
            if (currentStart == Long.MIN_VALUE) {
                currentStart = idx;
            } else if (previous + 1L != idx) {
                RowRange range = new RowRange(currentStart, previous);
                rowRanges.add(range);
                currentStart = idx;
            }
            previous = idx;
        }
        if (previous != Long.MIN_VALUE) {
            rowRanges.add(new RowRange(currentStart, previous));
        }
        return rowRanges.iterator();
    }

    void resetForNewBatch(int batchSize) {
        this.rowsToReadInBatch = batchSize;
    }

    void resetForNewPage(int totalValuesInPage, long pageFirstRowIndex) {
        this.valuesToReadInPage = totalValuesInPage;
        this.rowId = pageFirstRowIndex;
    }

    public long currentRangeStart() {
        return this.currentRange.start;
    }

    public long currentRangeEnd() {
        return this.currentRange.end;
    }

    public boolean isFinished() {
        return this.currentRange.equals(END_ROW_RANGE);
    }

    public boolean isMaxRange() {
        return this.currentRange.equals(MAX_ROW_RANGE);
    }

    public void nextRange() {
        this.currentRange = this.rowRanges == null ? MAX_ROW_RANGE : (!this.rowRanges.hasNext() ? END_ROW_RANGE : this.rowRanges.next());
    }

    public static class RowRange {
        final long start;
        final long end;

        RowRange(long start, long end) {
            this.start = start;
            this.end = end;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof RowRange)) {
                return false;
            }
            return ((RowRange)obj).start == this.start && ((RowRange)obj).end == this.end;
        }
    }
}

