/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table;

import java.io.Serializable;
import javax.annotation.Nullable;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.CatalogLoader;
import org.apache.paimon.catalog.CatalogLockContext;
import org.apache.paimon.catalog.CatalogLockFactory;
import org.apache.paimon.catalog.CatalogSnapshotCommit;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.catalog.RenamingSnapshotCommit;
import org.apache.paimon.catalog.SnapshotCommit;
import org.apache.paimon.table.PartitionHandler;
import org.apache.paimon.tag.SnapshotLoaderImpl;
import org.apache.paimon.utils.SnapshotLoader;
import org.apache.paimon.utils.SnapshotManager;

public class CatalogEnvironment
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Nullable
    private final Identifier identifier;
    @Nullable
    private final String uuid;
    @Nullable
    private final CatalogLoader catalogLoader;
    @Nullable
    private final CatalogLockFactory lockFactory;
    @Nullable
    private final CatalogLockContext lockContext;
    private final boolean supportsVersionManagement;

    public CatalogEnvironment(@Nullable Identifier identifier, @Nullable String uuid, @Nullable CatalogLoader catalogLoader, @Nullable CatalogLockFactory lockFactory, @Nullable CatalogLockContext lockContext, boolean supportsVersionManagement) {
        this.identifier = identifier;
        this.uuid = uuid;
        this.catalogLoader = catalogLoader;
        this.lockFactory = lockFactory;
        this.lockContext = lockContext;
        this.supportsVersionManagement = supportsVersionManagement;
    }

    public static CatalogEnvironment empty() {
        return new CatalogEnvironment(null, null, null, null, null, false);
    }

    @Nullable
    public Identifier identifier() {
        return this.identifier;
    }

    @Nullable
    public String uuid() {
        return this.uuid;
    }

    @Nullable
    public PartitionHandler partitionHandler() {
        if (this.catalogLoader == null) {
            return null;
        }
        Catalog catalog = this.catalogLoader.load();
        return PartitionHandler.create(catalog, this.identifier);
    }

    public boolean supportsVersionManagement() {
        return this.supportsVersionManagement;
    }

    @Nullable
    public SnapshotCommit snapshotCommit(SnapshotManager snapshotManager) {
        SnapshotCommit.Factory factory2 = this.catalogLoader != null && this.supportsVersionManagement ? new CatalogSnapshotCommit.Factory(this.catalogLoader) : new RenamingSnapshotCommit.Factory(this.lockFactory, this.lockContext);
        return factory2.create(this.identifier, snapshotManager);
    }

    @Nullable
    public SnapshotLoader snapshotLoader() {
        if (this.catalogLoader == null) {
            return null;
        }
        return new SnapshotLoaderImpl(this.catalogLoader, this.identifier);
    }

    @Nullable
    public CatalogLockFactory lockFactory() {
        return this.lockFactory;
    }

    @Nullable
    public CatalogLockContext lockContext() {
        return this.lockContext;
    }

    @Nullable
    public CatalogLoader catalogLoader() {
        return this.catalogLoader;
    }
}

