/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.serializer.InternalRowSerializer;
import org.apache.paimon.data.serializer.InternalSerializers;
import org.apache.paimon.io.DataInputView;
import org.apache.paimon.io.DataInputViewStreamWrapper;
import org.apache.paimon.io.DataOutputView;
import org.apache.paimon.io.DataOutputViewStreamWrapper;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.RowType;

public abstract class ObjectSerializer<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final InternalRowSerializer rowSerializer;

    public ObjectSerializer(RowType rowType) {
        this.rowSerializer = InternalSerializers.create(rowType);
    }

    public int numFields() {
        return this.rowSerializer.getArity();
    }

    public DataType[] fieldTypes() {
        return this.rowSerializer.fieldTypes();
    }

    public final void serialize(T record, DataOutputView target) throws IOException {
        this.rowSerializer.serialize(this.toRow(record), target);
    }

    public final T deserialize(DataInputView source2) throws IOException {
        return this.fromRow(this.rowSerializer.deserialize(source2));
    }

    public final void serializeList(List<T> records, DataOutputView target) throws IOException {
        target.writeInt(records.size());
        for (T t : records) {
            this.serialize(t, target);
        }
    }

    public final byte[] serializeList(List<T> records) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputViewStreamWrapper view = new DataOutputViewStreamWrapper(baos);
        this.serializeList(records, view);
        return baos.toByteArray();
    }

    public final List<T> deserializeList(DataInputView source2) throws IOException {
        int size = source2.readInt();
        ArrayList<T> records = new ArrayList<T>(size);
        for (int i = 0; i < size; ++i) {
            records.add(this.deserialize(source2));
        }
        return records;
    }

    public final List<T> deserializeList(byte[] bytes) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        DataInputViewStreamWrapper view = new DataInputViewStreamWrapper(bais);
        return this.deserializeList(view);
    }

    public byte[] serializeToBytes(T record) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataOutputViewStreamWrapper view = new DataOutputViewStreamWrapper(out);
        this.serialize(record, view);
        return out.toByteArray();
    }

    public T deserializeFromBytes(byte[] bytes) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        DataInputViewStreamWrapper view = new DataInputViewStreamWrapper(in);
        return this.deserialize(view);
    }

    public abstract InternalRow toRow(T var1);

    public abstract T fromRow(InternalRow var1);
}

