/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink;

import java.util.List;
import java.util.Optional;
import org.apache.flink.table.catalog.AbstractCatalog;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogDatabase;
import org.apache.flink.table.catalog.CatalogFunction;
import org.apache.flink.table.catalog.CatalogPartition;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.TableChange;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.catalog.exceptions.DatabaseAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.DatabaseNotEmptyException;
import org.apache.flink.table.catalog.exceptions.DatabaseNotExistException;
import org.apache.flink.table.catalog.exceptions.FunctionAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.FunctionNotExistException;
import org.apache.flink.table.catalog.exceptions.PartitionAlreadyExistsException;
import org.apache.flink.table.catalog.exceptions.PartitionNotExistException;
import org.apache.flink.table.catalog.exceptions.PartitionSpecInvalidException;
import org.apache.flink.table.catalog.exceptions.TableAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.TableNotExistException;
import org.apache.flink.table.catalog.exceptions.TableNotPartitionedException;
import org.apache.flink.table.catalog.exceptions.TablePartitionedException;
import org.apache.flink.table.catalog.stats.CatalogColumnStatistics;
import org.apache.flink.table.catalog.stats.CatalogTableStatistics;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.factories.Factory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.FunctionDefinitionFactory;
import org.apache.flink.table.factories.TableFactory;
import org.apache.paimon.flink.FlinkCatalog;
import org.apache.paimon.flink.FlinkGenericTableFactory;

public class FlinkGenericCatalog
extends AbstractCatalog {
    private final FlinkCatalog paimon;
    private final Catalog flink;

    public FlinkGenericCatalog(FlinkCatalog paimon, Catalog flink) {
        super(paimon.getName(), paimon.getDefaultDatabase());
        this.paimon = paimon;
        this.flink = flink;
    }

    public void open() throws CatalogException {
        this.paimon.open();
        this.flink.open();
    }

    public void close() throws CatalogException {
        this.paimon.close();
        this.flink.close();
    }

    public Optional<Factory> getFactory() {
        return Optional.of(new FlinkGenericTableFactory(this.paimon.getFactory().get(), (Factory)this.flink.getFactory().get()));
    }

    public Optional<TableFactory> getTableFactory() {
        return this.flink.getTableFactory();
    }

    public Optional<FunctionDefinitionFactory> getFunctionDefinitionFactory() {
        return this.flink.getFunctionDefinitionFactory();
    }

    public List<String> listDatabases() throws CatalogException {
        return this.flink.listDatabases();
    }

    public CatalogDatabase getDatabase(String databaseName) throws DatabaseNotExistException, CatalogException {
        return this.flink.getDatabase(databaseName);
    }

    public boolean databaseExists(String databaseName) throws CatalogException {
        return this.flink.databaseExists(databaseName);
    }

    public void createDatabase(String name, CatalogDatabase database, boolean ignoreIfExists) throws DatabaseAlreadyExistException, CatalogException {
        this.flink.createDatabase(name, database, ignoreIfExists);
    }

    public void dropDatabase(String name, boolean ignoreIfNotExists, boolean cascade) throws DatabaseNotExistException, DatabaseNotEmptyException, CatalogException {
        this.flink.dropDatabase(name, ignoreIfNotExists, cascade);
    }

    public void alterDatabase(String name, CatalogDatabase newDatabase, boolean ignoreIfNotExists) throws DatabaseNotExistException, CatalogException {
        this.flink.alterDatabase(name, newDatabase, ignoreIfNotExists);
    }

    public List<String> listTables(String databaseName) throws DatabaseNotExistException, CatalogException {
        return this.flink.listTables(databaseName);
    }

    public List<String> listViews(String databaseName) throws DatabaseNotExistException, CatalogException {
        return this.flink.listViews(databaseName);
    }

    public CatalogBaseTable getTable(ObjectPath tablePath) throws TableNotExistException, CatalogException {
        try {
            return this.paimon.getTable(tablePath);
        }
        catch (TableNotExistException e) {
            return this.flink.getTable(tablePath);
        }
    }

    public boolean tableExists(ObjectPath tablePath) throws CatalogException {
        if (this.isPaimonTable(tablePath)) {
            return true;
        }
        return this.flink.tableExists(tablePath);
    }

    public void dropTable(ObjectPath tablePath, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException {
        try {
            this.paimon.dropTable(tablePath, false);
        }
        catch (TableNotExistException e) {
            this.flink.dropTable(tablePath, ignoreIfNotExists);
        }
    }

    public void renameTable(ObjectPath tablePath, String newTableName, boolean ignoreIfNotExists) throws TableNotExistException, TableAlreadyExistException, CatalogException {
        try {
            this.paimon.renameTable(tablePath, newTableName, false);
        }
        catch (TableNotExistException e) {
            this.flink.renameTable(tablePath, newTableName, ignoreIfNotExists);
        }
    }

    public void createTable(ObjectPath tablePath, CatalogBaseTable table, boolean ignoreIfExists) throws TableAlreadyExistException, DatabaseNotExistException, CatalogException {
        String connector = (String)table.getOptions().get(FactoryUtil.CONNECTOR.key());
        if (connector == null) {
            throw new RuntimeException("FlinkGenericCatalog can not create table without 'connector' key.");
        }
        if ("paimon".equals(connector)) {
            this.paimon.createTable(tablePath, table, ignoreIfExists);
        } else {
            this.flink.createTable(tablePath, table, ignoreIfExists);
        }
    }

    private boolean isPaimonTable(ObjectPath tablePath) {
        try {
            this.paimon.getTable(tablePath);
            return true;
        }
        catch (TableNotExistException e) {
            return false;
        }
    }

    public void alterTable(ObjectPath tablePath, CatalogBaseTable newTable, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException {
        if (this.isPaimonTable(tablePath)) {
            this.paimon.alterTable(tablePath, newTable, ignoreIfNotExists);
        } else {
            this.flink.alterTable(tablePath, newTable, ignoreIfNotExists);
        }
    }

    public void alterTable(ObjectPath tablePath, CatalogBaseTable newTable, List<TableChange> tableChanges, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException {
        if (this.isPaimonTable(tablePath)) {
            this.paimon.alterTable(tablePath, newTable, tableChanges, ignoreIfNotExists);
        } else {
            this.flink.alterTable(tablePath, newTable, tableChanges, ignoreIfNotExists);
        }
    }

    public List<CatalogPartitionSpec> listPartitions(ObjectPath tablePath) throws TableNotExistException, TableNotPartitionedException, CatalogException {
        if (this.isPaimonTable(tablePath)) {
            return this.paimon.listPartitions(tablePath);
        }
        return this.flink.listPartitions(tablePath);
    }

    public List<CatalogPartitionSpec> listPartitions(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws TableNotExistException, TableNotPartitionedException, PartitionSpecInvalidException, CatalogException {
        if (this.isPaimonTable(tablePath)) {
            return this.paimon.listPartitions(tablePath, partitionSpec);
        }
        return this.flink.listPartitions(tablePath, partitionSpec);
    }

    public List<CatalogPartitionSpec> listPartitionsByFilter(ObjectPath tablePath, List<Expression> filters) throws TableNotExistException, TableNotPartitionedException, CatalogException {
        if (this.isPaimonTable(tablePath)) {
            return this.paimon.listPartitionsByFilter(tablePath, filters);
        }
        return this.flink.listPartitionsByFilter(tablePath, filters);
    }

    public CatalogPartition getPartition(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws PartitionNotExistException, CatalogException {
        if (this.isPaimonTable(tablePath)) {
            return this.paimon.getPartition(tablePath, partitionSpec);
        }
        return this.flink.getPartition(tablePath, partitionSpec);
    }

    public boolean partitionExists(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws CatalogException {
        if (this.isPaimonTable(tablePath)) {
            return this.paimon.partitionExists(tablePath, partitionSpec);
        }
        return this.flink.partitionExists(tablePath, partitionSpec);
    }

    public void createPartition(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, CatalogPartition partition, boolean ignoreIfExists) throws TableNotExistException, TableNotPartitionedException, PartitionSpecInvalidException, PartitionAlreadyExistsException, CatalogException {
        if (this.isPaimonTable(tablePath)) {
            this.paimon.createPartition(tablePath, partitionSpec, partition, ignoreIfExists);
        } else {
            this.flink.createPartition(tablePath, partitionSpec, partition, ignoreIfExists);
        }
    }

    public void dropPartition(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, boolean ignoreIfNotExists) throws PartitionNotExistException, CatalogException {
        if (this.isPaimonTable(tablePath)) {
            this.paimon.dropPartition(tablePath, partitionSpec, ignoreIfNotExists);
        } else {
            this.flink.dropPartition(tablePath, partitionSpec, ignoreIfNotExists);
        }
    }

    public void alterPartition(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, CatalogPartition newPartition, boolean ignoreIfNotExists) throws PartitionNotExistException, CatalogException {
        if (this.isPaimonTable(tablePath)) {
            this.paimon.alterPartition(tablePath, partitionSpec, newPartition, ignoreIfNotExists);
        } else {
            this.flink.alterPartition(tablePath, partitionSpec, newPartition, ignoreIfNotExists);
        }
    }

    public List<String> listFunctions(String dbName) throws DatabaseNotExistException, CatalogException {
        return this.flink.listFunctions(dbName);
    }

    public CatalogFunction getFunction(ObjectPath functionPath) throws FunctionNotExistException, CatalogException {
        return this.flink.getFunction(functionPath);
    }

    public boolean functionExists(ObjectPath functionPath) throws CatalogException {
        return this.flink.functionExists(functionPath);
    }

    public void createFunction(ObjectPath functionPath, CatalogFunction function, boolean ignoreIfExists) throws FunctionAlreadyExistException, DatabaseNotExistException, CatalogException {
        this.flink.createFunction(functionPath, function, ignoreIfExists);
    }

    public void alterFunction(ObjectPath functionPath, CatalogFunction newFunction, boolean ignoreIfNotExists) throws FunctionNotExistException, CatalogException {
        this.flink.alterFunction(functionPath, newFunction, ignoreIfNotExists);
    }

    public void dropFunction(ObjectPath functionPath, boolean ignoreIfNotExists) throws FunctionNotExistException, CatalogException {
        this.flink.dropFunction(functionPath, ignoreIfNotExists);
    }

    public CatalogTableStatistics getTableStatistics(ObjectPath tablePath) throws TableNotExistException, CatalogException {
        if (this.isPaimonTable(tablePath)) {
            return this.paimon.getTableStatistics(tablePath);
        }
        return this.flink.getTableStatistics(tablePath);
    }

    public CatalogColumnStatistics getTableColumnStatistics(ObjectPath tablePath) throws TableNotExistException, CatalogException {
        if (this.isPaimonTable(tablePath)) {
            return this.paimon.getTableColumnStatistics(tablePath);
        }
        return this.flink.getTableColumnStatistics(tablePath);
    }

    public CatalogTableStatistics getPartitionStatistics(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws PartitionNotExistException, CatalogException {
        if (this.isPaimonTable(tablePath)) {
            return this.paimon.getPartitionStatistics(tablePath, partitionSpec);
        }
        return this.flink.getPartitionStatistics(tablePath, partitionSpec);
    }

    public CatalogColumnStatistics getPartitionColumnStatistics(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws PartitionNotExistException, CatalogException {
        if (this.isPaimonTable(tablePath)) {
            return this.paimon.getPartitionColumnStatistics(tablePath, partitionSpec);
        }
        return this.flink.getPartitionColumnStatistics(tablePath, partitionSpec);
    }

    public void alterTableStatistics(ObjectPath tablePath, CatalogTableStatistics tableStatistics, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException {
        if (this.isPaimonTable(tablePath)) {
            this.paimon.alterTableStatistics(tablePath, tableStatistics, ignoreIfNotExists);
        } else {
            this.flink.alterTableStatistics(tablePath, tableStatistics, ignoreIfNotExists);
        }
    }

    public void alterTableColumnStatistics(ObjectPath tablePath, CatalogColumnStatistics columnStatistics, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException, TablePartitionedException {
        if (this.isPaimonTable(tablePath)) {
            this.paimon.alterTableColumnStatistics(tablePath, columnStatistics, ignoreIfNotExists);
        } else {
            this.flink.alterTableColumnStatistics(tablePath, columnStatistics, ignoreIfNotExists);
        }
    }

    public void alterPartitionStatistics(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, CatalogTableStatistics partitionStatistics, boolean ignoreIfNotExists) throws PartitionNotExistException, CatalogException {
        if (this.isPaimonTable(tablePath)) {
            this.paimon.alterPartitionStatistics(tablePath, partitionSpec, partitionStatistics, ignoreIfNotExists);
        } else {
            this.flink.alterPartitionStatistics(tablePath, partitionSpec, partitionStatistics, ignoreIfNotExists);
        }
    }

    public void alterPartitionColumnStatistics(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, CatalogColumnStatistics columnStatistics, boolean ignoreIfNotExists) throws PartitionNotExistException, CatalogException {
        if (this.isPaimonTable(tablePath)) {
            this.paimon.alterPartitionColumnStatistics(tablePath, partitionSpec, columnStatistics, ignoreIfNotExists);
        } else {
            this.flink.alterPartitionColumnStatistics(tablePath, partitionSpec, columnStatistics, ignoreIfNotExists);
        }
    }

    public List<CatalogTableStatistics> bulkGetPartitionStatistics(ObjectPath tablePath, List<CatalogPartitionSpec> partitionSpecs) throws PartitionNotExistException, CatalogException {
        if (this.isPaimonTable(tablePath)) {
            return this.paimon.bulkGetPartitionStatistics(tablePath, partitionSpecs);
        }
        return this.flink.bulkGetPartitionStatistics(tablePath, partitionSpecs);
    }

    public List<CatalogColumnStatistics> bulkGetPartitionColumnStatistics(ObjectPath tablePath, List<CatalogPartitionSpec> partitionSpecs) throws PartitionNotExistException, CatalogException {
        if (this.isPaimonTable(tablePath)) {
            return this.paimon.bulkGetPartitionColumnStatistics(tablePath, partitionSpecs);
        }
        return this.flink.bulkGetPartitionColumnStatistics(tablePath, partitionSpecs);
    }
}

