/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink;

import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.flink.AbstractFlinkTableFactory;
import org.apache.paimon.flink.FlinkCatalog;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.options.Options;
import org.apache.paimon.schema.SchemaManager;

public class FlinkTableFactory
extends AbstractFlinkTableFactory {
    public String factoryIdentifier() {
        return "paimon";
    }

    @Override
    public DynamicTableSource createDynamicTableSource(DynamicTableFactory.Context context) {
        if (this.isFlinkTable(context)) {
            return FactoryUtil.createTableSource(null, (ObjectIdentifier)context.getObjectIdentifier(), (ResolvedCatalogTable)context.getCatalogTable(), (ReadableConfig)context.getConfiguration(), (ClassLoader)context.getClassLoader(), (boolean)context.isTemporary());
        }
        this.createTableIfNeeded(context);
        return super.createDynamicTableSource(context);
    }

    @Override
    public DynamicTableSink createDynamicTableSink(DynamicTableFactory.Context context) {
        if (this.isFlinkTable(context)) {
            return FactoryUtil.createTableSink(null, (ObjectIdentifier)context.getObjectIdentifier(), (ResolvedCatalogTable)context.getCatalogTable(), (ReadableConfig)context.getConfiguration(), (ClassLoader)context.getClassLoader(), (boolean)context.isTemporary());
        }
        this.createTableIfNeeded(context);
        return super.createDynamicTableSink(context);
    }

    private void createTableIfNeeded(DynamicTableFactory.Context context) {
        ResolvedCatalogTable table = context.getCatalogTable();
        Options options = Options.fromMap(table.getOptions());
        if (options.get(CoreOptions.AUTO_CREATE).booleanValue()) {
            try {
                Path tablePath = CoreOptions.path(table.getOptions());
                SchemaManager schemaManager = new SchemaManager(FileIO.get(tablePath, FlinkTableFactory.createCatalogContext(context)), tablePath);
                if (!schemaManager.latest().isPresent()) {
                    schemaManager.createTable(FlinkCatalog.fromCatalogTable((CatalogTable)table));
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private boolean isFlinkTable(DynamicTableFactory.Context context) {
        String identifier = (String)context.getCatalogTable().getOptions().get(FactoryUtil.CONNECTOR.key());
        return identifier != null && !"paimon".equals(identifier);
    }
}

