/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class TypeMapping
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Set<TypeMappingMode> typeMappingModes;

    public TypeMapping(Set<TypeMappingMode> typeMappingModes) {
        this.typeMappingModes = typeMappingModes;
    }

    public boolean containsMode(TypeMappingMode mode) {
        return this.typeMappingModes.contains((Object)mode);
    }

    public static TypeMapping defaultMapping() {
        return new TypeMapping(Collections.emptySet());
    }

    public static TypeMapping parse(String[] rawOptions) {
        Set<TypeMappingMode> typeMappingModes = Arrays.stream(rawOptions).map(String::trim).map(String::toLowerCase).map(TypeMappingMode::mode).collect(Collectors.toSet());
        return new TypeMapping(typeMappingModes);
    }

    public static enum TypeMappingMode {
        TINYINT1_NOT_BOOL,
        TO_NULLABLE,
        TO_STRING,
        CHAR_TO_STRING,
        LONGTEXT_TO_BYTES;

        private static final Map<String, TypeMappingMode> TYPE_MAPPING_OPTIONS;

        public static TypeMappingMode mode(String option) {
            TypeMappingMode typeMappingMode = TYPE_MAPPING_OPTIONS.get(option);
            if (typeMappingMode == null) {
                throw new UnsupportedOperationException("Unsupported type mapping option: " + option);
            }
            return typeMappingMode;
        }

        public String configString() {
            return this.name().toLowerCase().replace("_", "-");
        }

        static {
            TYPE_MAPPING_OPTIONS = Arrays.stream(TypeMappingMode.values()).collect(Collectors.toMap(TypeMappingMode::configString, Function.identity()));
        }
    }
}

