/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc.mysql.schema;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.flink.action.cdc.mysql.schema.AllMergedMySqlTableInfo;
import org.apache.paimon.flink.action.cdc.mysql.schema.MySqlTableInfo;
import org.apache.paimon.flink.action.cdc.mysql.schema.ShardsMergedMySqlTableInfo;
import org.apache.paimon.flink.action.cdc.mysql.schema.UnmergedMySqlTableInfo;
import org.apache.paimon.schema.Schema;

public class MySqlSchemasInfo {
    private final Map<Identifier, Schema> pkTableSchemas = new HashMap<Identifier, Schema>();
    private final Map<Identifier, Schema> nonPkTableSchemas = new HashMap<Identifier, Schema>();

    public void addSchema(Identifier identifier, Schema mysqlSchema) {
        if (mysqlSchema.primaryKeys().isEmpty()) {
            this.nonPkTableSchemas.put(identifier, mysqlSchema);
        } else {
            this.pkTableSchemas.put(identifier, mysqlSchema);
        }
    }

    public List<Identifier> pkTables() {
        return new ArrayList<Identifier>(this.pkTableSchemas.keySet());
    }

    public List<Identifier> nonPkTables() {
        return new ArrayList<Identifier>(this.nonPkTableSchemas.keySet());
    }

    public MySqlTableInfo mergeAll() {
        boolean initialized = false;
        AllMergedMySqlTableInfo merged = new AllMergedMySqlTableInfo();
        for (Map.Entry<Identifier, Schema> entry : this.pkTableSchemas.entrySet()) {
            Identifier id = entry.getKey();
            Schema schema = entry.getValue();
            if (!initialized) {
                merged.init(id, schema);
                initialized = true;
                continue;
            }
            merged.merge(id, schema);
        }
        return merged;
    }

    public List<MySqlTableInfo> toMySqlTableInfos(boolean mergeShards) {
        if (mergeShards) {
            return this.mergeShards();
        }
        return this.pkTableSchemas.entrySet().stream().map(e -> new UnmergedMySqlTableInfo((Identifier)e.getKey(), (Schema)e.getValue())).collect(Collectors.toList());
    }

    private List<MySqlTableInfo> mergeShards() {
        HashMap<String, ShardsMergedMySqlTableInfo> nameSchemaMap = new HashMap<String, ShardsMergedMySqlTableInfo>();
        for (Map.Entry<Identifier, Schema> entry : this.pkTableSchemas.entrySet()) {
            Identifier id = entry.getKey();
            String tableName = id.getObjectName();
            Schema toBeMerged = entry.getValue();
            ShardsMergedMySqlTableInfo current = (ShardsMergedMySqlTableInfo)nameSchemaMap.get(tableName);
            if (current == null) {
                current = new ShardsMergedMySqlTableInfo();
                current.init(id, toBeMerged);
                nameSchemaMap.put(tableName, current);
                continue;
            }
            nameSchemaMap.put(tableName, current.merge(id, toBeMerged));
        }
        return new ArrayList<MySqlTableInfo>(nameSchemaMap.values());
    }
}

