/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.lookup;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.serializer.InternalSerializers;
import org.apache.paimon.flink.lookup.PrimaryKeyLookupTable;
import org.apache.paimon.lookup.RocksDBSetState;
import org.apache.paimon.lookup.RocksDBStateFactory;
import org.apache.paimon.types.RowKind;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.KeyProjectedRow;
import org.apache.paimon.utils.TypeUtils;

public class SecondaryIndexLookupTable
extends PrimaryKeyLookupTable {
    private final RocksDBSetState<InternalRow, InternalRow> indexState;
    private final KeyProjectedRow secKeyRow;

    public SecondaryIndexLookupTable(RocksDBStateFactory stateFactory, RowType rowType, List<String> primaryKey, List<String> secKey, Predicate<InternalRow> recordFilter, long lruCacheSize) throws IOException {
        super(stateFactory, rowType, primaryKey, recordFilter, lruCacheSize / 2L);
        List<String> fieldNames = rowType.getFieldNames();
        int[] secKeyMapping = secKey.stream().mapToInt(fieldNames::indexOf).toArray();
        this.secKeyRow = new KeyProjectedRow(secKeyMapping);
        this.indexState = stateFactory.setState("sec-index", InternalSerializers.create(TypeUtils.project(rowType, secKeyMapping)), InternalSerializers.create(TypeUtils.project(rowType, this.primaryKeyMapping)), lruCacheSize / 2L);
    }

    @Override
    public List<InternalRow> get(InternalRow key) throws IOException {
        List<InternalRow> pks = this.indexState.get(key);
        ArrayList<InternalRow> values = new ArrayList<InternalRow>(pks.size());
        for (InternalRow pk : pks) {
            InternalRow value = (InternalRow)this.tableState.get(pk);
            if (value == null) continue;
            values.add(value);
        }
        return values;
    }

    @Override
    public void refresh(Iterator<InternalRow> incremental) throws IOException {
        while (incremental.hasNext()) {
            InternalRow row = incremental.next();
            this.primaryKey.replaceRow(row);
            if (row.getRowKind() == RowKind.INSERT || row.getRowKind() == RowKind.UPDATE_AFTER) {
                InternalRow previous = (InternalRow)this.tableState.get(this.primaryKey);
                if (previous != null) {
                    this.indexState.retract(this.secKeyRow.replaceRow(previous), this.primaryKey);
                }
                if (this.recordFilter.test(row)) {
                    this.tableState.put(this.primaryKey, row);
                    this.indexState.add(this.secKeyRow.replaceRow(row), this.primaryKey);
                    continue;
                }
                this.tableState.delete(this.primaryKey);
                continue;
            }
            this.tableState.delete(this.primaryKey);
            this.indexState.retract(this.secKeyRow.replaceRow(row), this.primaryKey);
        }
    }
}

