/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.lookup;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.IntUnaryOperator;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.mergetree.compact.ConcatRecordReader;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.predicate.PredicateBuilder;
import org.apache.paimon.predicate.PredicateFilter;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.shade.guava30.com.google.common.primitives.Ints;
import org.apache.paimon.table.Table;
import org.apache.paimon.table.source.EndOfScanException;
import org.apache.paimon.table.source.ReadBuilder;
import org.apache.paimon.table.source.Split;
import org.apache.paimon.table.source.StreamTableScan;
import org.apache.paimon.table.source.TableRead;
import org.apache.paimon.table.source.TableScan;
import org.apache.paimon.utils.TypeUtils;

public class TableStreamingReader {
    private final ReadBuilder readBuilder;
    @Nullable
    private final PredicateFilter recordFilter;
    private final StreamTableScan scan;

    public TableStreamingReader(Table table, int[] projection, @Nullable Predicate predicate) {
        if (CoreOptions.fromMap(table.options()).startupMode() != CoreOptions.StartupMode.COMPACTED_FULL) {
            table = table.copy(Collections.singletonMap(CoreOptions.SCAN_MODE.key(), CoreOptions.StartupMode.LATEST_FULL.toString()));
        }
        this.readBuilder = table.newReadBuilder().withProjection(projection).withFilter(predicate);
        this.scan = this.readBuilder.newStreamScan();
        if (predicate != null) {
            List<String> fieldNames = table.rowType().getFieldNames();
            List<String> primaryKeys = table.primaryKeys();
            IntUnaryOperator operator = i -> {
                int index = Ints.indexOf(projection, i);
                boolean safeFilter = primaryKeys.isEmpty() || primaryKeys.contains(fieldNames.get(i));
                return safeFilter ? index : -1;
            };
            int[] fieldIdxToProjectionIdx = IntStream.range(0, table.rowType().getFieldCount()).map(operator).toArray();
            this.recordFilter = new PredicateFilter(TypeUtils.project(table.rowType(), projection), PredicateBuilder.transformFieldMapping(predicate, fieldIdxToProjectionIdx).orElse(null));
        } else {
            this.recordFilter = null;
        }
    }

    public RecordReader<InternalRow> nextBatch() throws Exception {
        try {
            return this.read(this.scan.plan());
        }
        catch (EndOfScanException e) {
            throw new IllegalArgumentException("TableStreamingReader does not support finished enumerator.", e);
        }
    }

    private RecordReader<InternalRow> read(TableScan.Plan plan) throws IOException {
        TableRead read = this.readBuilder.newRead();
        ArrayList readers = new ArrayList();
        for (Split split : plan.splits()) {
            readers.add(() -> read.createReader(split));
        }
        RecordReader<InternalRow> reader = ConcatRecordReader.create(readers);
        if (this.recordFilter != null) {
            reader = reader.filter(this.recordFilter::test);
        }
        return reader;
    }
}

