/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.append.AppendOnlyCompactionTask;
import org.apache.paimon.flink.sink.Committable;
import org.apache.paimon.flink.sink.PrepareCommitOperator;
import org.apache.paimon.operation.AppendOnlyFileStoreWrite;
import org.apache.paimon.options.Options;
import org.apache.paimon.table.AppendOnlyFileStoreTable;
import org.apache.paimon.table.sink.CommitMessage;
import org.apache.paimon.table.sink.TableCommitImpl;
import org.apache.paimon.utils.ExecutorThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppendOnlyTableCompactionWorkerOperator
extends PrepareCommitOperator<AppendOnlyCompactionTask, Committable> {
    private static final Logger LOG = LoggerFactory.getLogger(AppendOnlyTableCompactionWorkerOperator.class);
    private final AppendOnlyFileStoreTable table;
    private final String commitUser;
    private transient AppendOnlyFileStoreWrite write;
    private transient ExecutorService lazyCompactExecutor;
    private transient Queue<Future<CommitMessage>> result;

    public AppendOnlyTableCompactionWorkerOperator(AppendOnlyFileStoreTable table, String commitUser) {
        super(Options.fromMap(table.options()));
        this.table = table;
        this.commitUser = commitUser;
    }

    @VisibleForTesting
    Iterable<Future<CommitMessage>> result() {
        return this.result;
    }

    public void open() throws Exception {
        LOG.debug("Opened a append-only table compaction worker.");
        this.write = this.table.store().newWrite(this.commitUser);
        this.result = new LinkedList<Future<CommitMessage>>();
    }

    @Override
    protected List<Committable> prepareCommit(boolean waitCompaction, long checkpointId) throws IOException {
        ArrayList<CommitMessage> tempList = new ArrayList<CommitMessage>();
        try {
            Future<CommitMessage> future;
            while (!this.result.isEmpty() && ((future = this.result.peek()).isDone() || waitCompaction)) {
                this.result.poll();
                tempList.add(future.get());
            }
            return tempList.stream().map(s -> new Committable(checkpointId, Committable.Kind.FILE, s)).collect(Collectors.toList());
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while waiting tasks done.", e);
        }
        catch (Exception e) {
            throw new RuntimeException("Encountered an error while do compaction", e);
        }
    }

    public void processElement(StreamRecord<AppendOnlyCompactionTask> element) throws Exception {
        AppendOnlyCompactionTask task = (AppendOnlyCompactionTask)element.getValue();
        this.result.add(this.workerExecutor().submit(() -> task.doCompact(this.write)));
    }

    private ExecutorService workerExecutor() {
        if (this.lazyCompactExecutor == null) {
            this.lazyCompactExecutor = Executors.newSingleThreadScheduledExecutor(new ExecutorThreadFactory(Thread.currentThread().getName() + "-append-only-compact-worker"));
        }
        return this.lazyCompactExecutor;
    }

    @Override
    public void close() throws Exception {
        this.shutdown();
    }

    @VisibleForTesting
    void shutdown() throws Exception {
        if (this.lazyCompactExecutor != null) {
            Future resultFuture;
            this.lazyCompactExecutor.shutdownNow();
            if (!this.lazyCompactExecutor.awaitTermination(120L, TimeUnit.SECONDS)) {
                LOG.warn("Executors shutdown timeout, there may be some files aren't deleted correctly");
            }
            ArrayList<CommitMessage> messages = new ArrayList<CommitMessage>();
            Iterator iterator = this.result.iterator();
            while (iterator.hasNext() && (resultFuture = (Future)iterator.next()).isDone()) {
                try {
                    messages.add((CommitMessage)resultFuture.get());
                }
                catch (Exception exception) {}
            }
            if (messages.isEmpty()) {
                return;
            }
            try (TableCommitImpl tableCommit = this.table.newCommit(this.commitUser);){
                tableCommit.abort(messages);
            }
        }
    }
}

