/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.flink.sink.Committable;
import org.apache.paimon.flink.sink.CommittableSerializer;
import org.apache.paimon.flink.sink.LogOffsetCommittable;
import org.apache.paimon.flink.sink.MultiTableCommittable;
import org.apache.paimon.table.sink.CommitMessage;
import org.apache.paimon.table.sink.CommitMessageSerializer;

public class MultiTableCommittableSerializer
implements SimpleVersionedSerializer<MultiTableCommittable> {
    private final CommittableSerializer committableSerializer;
    private final CommitMessageSerializer commitMessageSerializer;

    public MultiTableCommittableSerializer(CommitMessageSerializer commitMessageSerializer) {
        this.committableSerializer = new CommittableSerializer(commitMessageSerializer);
        this.commitMessageSerializer = commitMessageSerializer;
    }

    public int getVersion() {
        return 2;
    }

    public byte[] serialize(MultiTableCommittable committable) throws IOException {
        String database = committable.getDatabase();
        int databaseLen = database.length();
        String table = committable.getTable();
        int tableLen = table.length();
        int multiTableMetaLen = databaseLen + tableLen + 8;
        byte[] serializedCommittable = this.serializeCommittable(committable);
        return ByteBuffer.allocate(multiTableMetaLen + serializedCommittable.length).putInt(databaseLen).put(database.getBytes()).putInt(tableLen).put(table.getBytes()).put(serializedCommittable).array();
    }

    public MultiTableCommittable deserialize(int committableVersion, byte[] bytes) throws IOException {
        if (committableVersion != this.getVersion()) {
            throw new RuntimeException("Can not deserialize version: " + committableVersion);
        }
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        int databaseLen = buffer.getInt();
        byte[] databaseBytes = new byte[databaseLen];
        buffer.get(databaseBytes, 0, databaseLen);
        String database = new String(databaseBytes);
        int tableLen = buffer.getInt();
        byte[] tableBytes = new byte[tableLen];
        buffer.get(tableBytes, 0, tableLen);
        String table = new String(tableBytes);
        int multiTableMetaLen = databaseLen + tableLen + 8;
        byte[] serializedCommittable = new byte[bytes.length - multiTableMetaLen];
        buffer.get(serializedCommittable, 0, bytes.length - multiTableMetaLen);
        Committable committable = this.deserializeCommittable(committableVersion, serializedCommittable);
        return MultiTableCommittable.fromCommittable(Identifier.create(database, table), committable);
    }

    public byte[] serializeCommittable(MultiTableCommittable committable) throws IOException {
        byte[] wrapped;
        int version;
        switch (committable.kind()) {
            case FILE: {
                version = this.commitMessageSerializer.getVersion();
                wrapped = this.commitMessageSerializer.serialize((CommitMessage)committable.wrappedCommittable());
                break;
            }
            case LOG_OFFSET: {
                version = 1;
                wrapped = ((LogOffsetCommittable)committable.wrappedCommittable()).toBytes();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported kind: " + (Object)((Object)committable.kind()));
            }
        }
        return ByteBuffer.allocate(9 + wrapped.length + 4).putLong(committable.checkpointId()).put(committable.kind().toByteValue()).put(wrapped).putInt(version).array();
    }

    public Committable deserializeCommittable(int committableVersion, byte[] bytes) throws IOException {
        Object wrappedCommittable;
        if (committableVersion != this.getVersion()) {
            throw new RuntimeException("Can not deserialize version: " + committableVersion);
        }
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        long checkpointId = buffer.getLong();
        Committable.Kind kind = Committable.Kind.fromByteValue(buffer.get());
        byte[] wrapped = new byte[bytes.length - 13];
        buffer.get(wrapped);
        int version = buffer.getInt();
        switch (kind) {
            case FILE: {
                wrappedCommittable = this.commitMessageSerializer.deserialize(version, wrapped);
                break;
            }
            case LOG_OFFSET: {
                wrappedCommittable = LogOffsetCommittable.fromBytes(wrapped);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported kind: " + (Object)((Object)kind));
            }
        }
        return new Committable(checkpointId, kind, wrappedCommittable);
    }
}

