/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink;

import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSink;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.paimon.append.AppendOnlyCompactionTask;
import org.apache.paimon.flink.sink.AppendOnlyTableCompactionWorkerOperator;
import org.apache.paimon.flink.sink.Committable;
import org.apache.paimon.flink.sink.CommittableStateManager;
import org.apache.paimon.flink.sink.Committer;
import org.apache.paimon.flink.sink.FlinkSink;
import org.apache.paimon.flink.sink.NoopCommittableStateManager;
import org.apache.paimon.flink.sink.StoreCommitter;
import org.apache.paimon.flink.sink.StoreSinkWrite;
import org.apache.paimon.manifest.ManifestCommittable;
import org.apache.paimon.table.AppendOnlyFileStoreTable;

public class UnawareBucketCompactionSink
extends FlinkSink<AppendOnlyCompactionTask> {
    private final AppendOnlyFileStoreTable table;

    public UnawareBucketCompactionSink(AppendOnlyFileStoreTable table) {
        super(table, true);
        this.table = table;
    }

    public static DataStreamSink<?> sink(AppendOnlyFileStoreTable table, DataStream<AppendOnlyCompactionTask> input) {
        return new UnawareBucketCompactionSink(table).sinkFrom(input);
    }

    @Override
    protected OneInputStreamOperator<AppendOnlyCompactionTask, Committable> createWriteOperator(StoreSinkWrite.Provider writeProvider, String commitUser) {
        return new AppendOnlyTableCompactionWorkerOperator(this.table, commitUser);
    }

    @Override
    protected Committer.Factory<Committable, ManifestCommittable> createCommitterFactory(boolean streamingCheckpointEnabled) {
        return (s, metricGroup) -> new StoreCommitter(this.table.newCommit(s), metricGroup);
    }

    @Override
    protected CommittableStateManager<ManifestCommittable> createCommittableStateManager() {
        return new NoopCommittableStateManager();
    }
}

