/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink.cdc;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.flink.sink.ChannelComputer;
import org.apache.paimon.flink.sink.cdc.CdcMultiplexRecord;
import org.apache.paimon.flink.sink.cdc.CdcRecord;
import org.apache.paimon.flink.sink.cdc.CdcRecordChannelComputer;
import org.apache.paimon.table.FileStoreTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdcMultiplexRecordChannelComputer
implements ChannelComputer<CdcMultiplexRecord> {
    private static final Logger LOG = LoggerFactory.getLogger(CdcMultiplexRecordChannelComputer.class);
    private static final long serialVersionUID = 1L;
    private final Catalog.Loader catalogLoader;
    private transient int numChannels;
    private Map<Identifier, CdcRecordChannelComputer> channelComputers;
    private Catalog catalog;
    private final Map<String, String> dynamicOptions;

    public CdcMultiplexRecordChannelComputer(Catalog.Loader catalogLoader, Map<String, String> dynamicOptions) {
        this.catalogLoader = catalogLoader;
        this.dynamicOptions = dynamicOptions;
    }

    @Override
    public void setup(int numChannels) {
        this.numChannels = numChannels;
        this.catalog = this.catalogLoader.load();
        this.channelComputers = new HashMap<Identifier, CdcRecordChannelComputer>();
    }

    @Override
    public int channel(CdcMultiplexRecord multiplexRecord) {
        ChannelComputer<CdcRecord> channelComputer = this.computeChannelComputer(multiplexRecord);
        int recordChannel = channelComputer != null ? channelComputer.channel(multiplexRecord.record()) : 0;
        return Math.floorMod(Objects.hash(multiplexRecord.databaseName(), multiplexRecord.tableName()) + recordChannel, this.numChannels);
    }

    private ChannelComputer<CdcRecord> computeChannelComputer(CdcMultiplexRecord record) {
        return this.channelComputers.computeIfAbsent(Identifier.create(record.databaseName(), record.tableName()), id -> {
            FileStoreTable table;
            try {
                table = (FileStoreTable)this.catalog.getTable((Identifier)id);
                table.copy((Map)this.dynamicOptions);
            }
            catch (Catalog.TableNotExistException e) {
                LOG.error("Failed to get table " + id.getFullName());
                return null;
            }
            CdcRecordChannelComputer channelComputer = new CdcRecordChannelComputer(table.schema());
            channelComputer.setup(this.numChannels);
            return channelComputer;
        });
    }

    public String toString() {
        return "shuffle by bucket";
    }
}

