/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink.cdc;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.paimon.flink.action.cdc.CdcActionCommonUtils;
import org.apache.paimon.flink.sink.cdc.RichCdcMultiplexRecord;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.types.DataType;

public class NewTableSchemaBuilder
implements Serializable {
    private final Map<String, String> tableConfig;
    private final boolean caseSensitive;

    public NewTableSchemaBuilder(Map<String, String> tableConfig, boolean caseSensitive) {
        this.tableConfig = tableConfig;
        this.caseSensitive = caseSensitive;
    }

    public Optional<Schema> build(RichCdcMultiplexRecord record) {
        Schema.Builder builder = Schema.newBuilder();
        builder.options(this.tableConfig);
        String tableName = record.tableName();
        tableName = tableName == null ? "UNKNOWN" : tableName;
        LinkedHashMap<String, DataType> fieldTypes = CdcActionCommonUtils.mapKeyCaseConvert(record.fieldTypes(), this.caseSensitive, CdcActionCommonUtils.columnDuplicateErrMsg(tableName));
        for (Map.Entry<String, DataType> entry : fieldTypes.entrySet()) {
            builder.column(entry.getKey(), entry.getValue());
        }
        builder.primaryKey(CdcActionCommonUtils.listCaseConvert(record.primaryKeys(), this.caseSensitive));
        return Optional.of(builder.build());
    }
}

