/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink.cdc;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.paimon.flink.sink.cdc.CdcRecord;
import org.apache.paimon.flink.sink.cdc.RichCdcRecord;
import org.apache.paimon.types.DataType;

public class RichCdcMultiplexRecord
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Nullable
    private final String databaseName;
    @Nullable
    private final String tableName;
    private final LinkedHashMap<String, DataType> fieldTypes;
    private final List<String> primaryKeys;
    private final CdcRecord cdcRecord;

    public RichCdcMultiplexRecord(@Nullable String databaseName, @Nullable String tableName, LinkedHashMap<String, DataType> fieldTypes, List<String> primaryKeys, CdcRecord cdcRecord) {
        this.databaseName = databaseName;
        this.tableName = tableName;
        this.fieldTypes = fieldTypes;
        this.primaryKeys = primaryKeys;
        this.cdcRecord = cdcRecord;
    }

    @Nullable
    public String databaseName() {
        return this.databaseName;
    }

    @Nullable
    public String tableName() {
        return this.tableName;
    }

    public LinkedHashMap<String, DataType> fieldTypes() {
        return this.fieldTypes;
    }

    public List<String> primaryKeys() {
        return this.primaryKeys;
    }

    public RichCdcRecord toRichCdcRecord() {
        return new RichCdcRecord(this.cdcRecord, this.fieldTypes);
    }

    public int hashCode() {
        return Objects.hash(this.databaseName, this.tableName, this.fieldTypes, this.primaryKeys, this.cdcRecord);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RichCdcMultiplexRecord that = (RichCdcMultiplexRecord)o;
        return Objects.equals(this.databaseName, that.databaseName) && Objects.equals(this.tableName, that.tableName) && Objects.equals(this.fieldTypes, that.fieldTypes) && Objects.equals(this.primaryKeys, that.primaryKeys) && Objects.equals(this.cdcRecord, that.cdcRecord);
    }

    public String toString() {
        return "{databaseName=" + this.databaseName + ", tableName=" + this.tableName + ", fieldTypes=" + this.fieldTypes + ", primaryKeys=" + this.primaryKeys + ", cdcRecord=" + this.cdcRecord + '}';
    }
}

