/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink.cdc;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.paimon.annotation.Experimental;
import org.apache.paimon.flink.sink.cdc.CdcRecord;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.RowKind;

@Experimental
public class RichCdcRecord
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final CdcRecord cdcRecord;
    private final LinkedHashMap<String, DataType> fieldTypes;

    public RichCdcRecord(CdcRecord cdcRecord, LinkedHashMap<String, DataType> fieldTypes) {
        this.cdcRecord = cdcRecord;
        this.fieldTypes = fieldTypes;
    }

    public boolean hasPayload() {
        return !this.cdcRecord.fields().isEmpty();
    }

    public RowKind kind() {
        return this.cdcRecord.kind();
    }

    public LinkedHashMap<String, DataType> fieldTypes() {
        return this.fieldTypes;
    }

    public CdcRecord toCdcRecord() {
        return this.cdcRecord;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RichCdcRecord that = (RichCdcRecord)o;
        return this.cdcRecord == that.cdcRecord && Objects.equals(this.fieldTypes, that.fieldTypes);
    }

    public int hashCode() {
        return Objects.hash(this.cdcRecord, this.fieldTypes);
    }

    public String toString() {
        return "{cdcRecord=" + this.cdcRecord + ", fieldTypes=" + this.fieldTypes + '}';
    }

    public static Builder builder(RowKind kind) {
        return new Builder(kind);
    }

    public static class Builder {
        private final RowKind kind;
        private final LinkedHashMap<String, DataType> fieldTypes = new LinkedHashMap();
        private final Map<String, String> fieldValues = new HashMap<String, String>();

        public Builder(RowKind kind) {
            this.kind = kind;
        }

        public Builder field(String name, DataType type, String value) {
            this.fieldTypes.put(name, type);
            this.fieldValues.put(name, value);
            return this;
        }

        public RichCdcRecord build() {
            return new RichCdcRecord(new CdcRecord(this.kind, this.fieldValues), this.fieldTypes);
        }
    }
}

