/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.mergetree.compact;

import java.util.function.Function;
import org.apache.paimon.KeyValue;
import org.apache.paimon.codegen.RecordEqualiser;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.mergetree.compact.ChangelogResult;
import org.apache.paimon.mergetree.compact.LookupMergeFunction;
import org.apache.paimon.mergetree.compact.MergeFunction;
import org.apache.paimon.mergetree.compact.MergeFunctionFactory;
import org.apache.paimon.mergetree.compact.MergeFunctionWrapper;
import org.apache.paimon.types.RowKind;
import org.apache.paimon.utils.Preconditions;

public class LookupChangelogMergeFunctionWrapper
implements MergeFunctionWrapper<ChangelogResult> {
    private final LookupMergeFunction mergeFunction;
    private final MergeFunction<KeyValue> mergeFunction2;
    private final Function<InternalRow, KeyValue> lookup;
    private final ChangelogResult reusedResult = new ChangelogResult();
    private final KeyValue reusedBefore = new KeyValue();
    private final KeyValue reusedAfter = new KeyValue();
    private final RecordEqualiser valueEqualiser;
    private final boolean changelogRowDeduplicate;

    public LookupChangelogMergeFunctionWrapper(MergeFunctionFactory<KeyValue> mergeFunctionFactory, Function<InternalRow, KeyValue> lookup, RecordEqualiser valueEqualiser, boolean changelogRowDeduplicate) {
        MergeFunction<KeyValue> mergeFunction = mergeFunctionFactory.create();
        Preconditions.checkArgument(mergeFunction instanceof LookupMergeFunction, "Merge function should be a LookupMergeFunction, but is %s, there is a bug.", mergeFunction.getClass().getName());
        this.mergeFunction = (LookupMergeFunction)mergeFunction;
        this.mergeFunction2 = mergeFunctionFactory.create();
        this.lookup = lookup;
        this.valueEqualiser = valueEqualiser;
        this.changelogRowDeduplicate = changelogRowDeduplicate;
    }

    @Override
    public void reset() {
        this.mergeFunction.reset();
    }

    @Override
    public void add(KeyValue kv) {
        this.mergeFunction.add(kv);
    }

    @Override
    public ChangelogResult getResult() {
        this.reusedResult.reset();
        KeyValue result = this.mergeFunction.getResult();
        if (result == null) {
            return this.reusedResult;
        }
        KeyValue highLevel = this.mergeFunction.highLevel;
        boolean containLevel0 = this.mergeFunction.containLevel0;
        if (!containLevel0) {
            return this.reusedResult.setResult(result);
        }
        if (highLevel != null) {
            this.setChangelog(highLevel, result);
            return this.reusedResult.setResult(result);
        }
        highLevel = this.lookup.apply(result.key());
        if (highLevel != null) {
            this.mergeFunction2.reset();
            this.mergeFunction2.add(highLevel);
            this.mergeFunction2.add(result);
            result = this.mergeFunction2.getResult();
            this.setChangelog(highLevel, result);
        } else {
            this.setChangelog(null, result);
        }
        return this.reusedResult.setResult(result);
    }

    private void setChangelog(KeyValue before, KeyValue after) {
        if (before == null || !this.isAdd(before)) {
            if (this.isAdd(after)) {
                this.reusedResult.addChangelog(this.replaceAfter(RowKind.INSERT, after));
            }
        } else if (!this.isAdd(after)) {
            this.reusedResult.addChangelog(this.replaceBefore(RowKind.DELETE, before));
        } else if (!this.changelogRowDeduplicate || !this.valueEqualiser.equals(before.value(), after.value())) {
            this.reusedResult.addChangelog(this.replaceBefore(RowKind.UPDATE_BEFORE, before)).addChangelog(this.replaceAfter(RowKind.UPDATE_AFTER, after));
        }
    }

    private KeyValue replaceBefore(RowKind valueKind, KeyValue from) {
        return this.replace(this.reusedBefore, valueKind, from);
    }

    private KeyValue replaceAfter(RowKind valueKind, KeyValue from) {
        return this.replace(this.reusedAfter, valueKind, from);
    }

    private KeyValue replace(KeyValue reused, RowKind valueKind, KeyValue from) {
        return reused.replace(from.key(), from.sequenceNumber(), valueKind, from.value());
    }

    private boolean isAdd(KeyValue kv) {
        return kv.valueKind() == RowKind.INSERT || kv.valueKind() == RowKind.UPDATE_AFTER;
    }
}

