/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action;

import java.util.Map;
import java.util.Optional;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.paimon.flink.action.Action;
import org.apache.paimon.flink.action.ActionFactory;
import org.apache.paimon.flink.action.MultipleParameterToolAdapter;
import org.apache.paimon.flink.action.RemoveOrphanFilesAction;

public class RemoveOrphanFilesActionFactory
implements ActionFactory {
    public static final String IDENTIFIER = "remove_orphan_files";
    private static final String OLDER_THAN = "older_than";

    @Override
    public String identifier() {
        return IDENTIFIER;
    }

    @Override
    public Optional<Action> create(MultipleParameterToolAdapter params) {
        Tuple3<String, String, String> tablePath = this.getTablePath(params);
        Map<String, String> catalogConfig = this.optionalConfigMap(params, "catalog_conf");
        RemoveOrphanFilesAction action = new RemoveOrphanFilesAction((String)tablePath.f0, (String)tablePath.f1, (String)tablePath.f2, catalogConfig);
        if (params.has(OLDER_THAN)) {
            action.olderThan(params.get(OLDER_THAN));
        }
        return Optional.of(action);
    }

    @Override
    public void printHelp() {
        System.out.println("Action \"remove_orphan_files\" remove files which are not used by any snapshots or tags of a Paimon table.");
        System.out.println();
        System.out.println("Syntax:");
        System.out.println("  remove_orphan_files --warehouse <warehouse_path> --database <database_name> --table <table_name> [--older_than <timestamp>]");
        System.out.println();
        System.out.println("To avoid deleting newly written files, this action only deletes orphan files older than 1 day by default. The interval can be modified by '--older_than'. <timestamp> format: yyyy-MM-dd HH:mm:ss");
        System.out.println();
    }
}

