/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink.cdc;

import java.io.Serializable;
import java.util.Objects;
import org.apache.paimon.flink.sink.cdc.CdcRecord;

public class CdcMultiplexRecord
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String databaseName;
    private final String tableName;
    private final CdcRecord record;

    public CdcMultiplexRecord(String databaseName, String tableName, CdcRecord record) {
        this.databaseName = databaseName;
        this.tableName = tableName;
        this.record = record;
    }

    public static CdcMultiplexRecord fromCdcRecord(String databaseName, String tableName, CdcRecord record) {
        return new CdcMultiplexRecord(databaseName, tableName, record);
    }

    public String databaseName() {
        return this.databaseName;
    }

    public String tableName() {
        return this.tableName;
    }

    public CdcRecord record() {
        return this.record;
    }

    public boolean equals(Object o) {
        if (!(o instanceof CdcMultiplexRecord)) {
            return false;
        }
        CdcMultiplexRecord that = (CdcMultiplexRecord)o;
        return Objects.equals(this.databaseName, that.databaseName) && Objects.equals(this.tableName, that.tableName) && Objects.equals(this.record, that.record);
    }

    public String toString() {
        return this.databaseName + "." + this.tableName + " " + this.record.toString();
    }
}

