/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.source.snapshot;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.paimon.Snapshot;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.table.source.DataSplit;
import org.apache.paimon.table.source.DeletionFile;
import org.apache.paimon.table.source.PlanImpl;
import org.apache.paimon.table.source.ScanMode;
import org.apache.paimon.table.source.Split;
import org.apache.paimon.table.source.SplitGenerator;
import org.apache.paimon.table.source.snapshot.AbstractStartingScanner;
import org.apache.paimon.table.source.snapshot.SnapshotReader;
import org.apache.paimon.table.source.snapshot.StartingScanner;
import org.apache.paimon.utils.SnapshotManager;

public class IncrementalStartingScanner
extends AbstractStartingScanner {
    private long endingSnapshotId;
    private ScanMode scanMode;

    public IncrementalStartingScanner(SnapshotManager snapshotManager, long start, long end, ScanMode scanMode) {
        super(snapshotManager);
        this.startingSnapshotId = start;
        this.endingSnapshotId = end;
        this.scanMode = scanMode;
    }

    @Override
    public StartingScanner.Result scan(SnapshotReader reader) {
        HashMap<SplitInfo, List> grouped = new HashMap<SplitInfo, List>();
        for (long i = this.startingSnapshotId + 1L; i < this.endingSnapshotId + 1L; ++i) {
            List<DataSplit> splits = this.readSplits(reader, this.snapshotManager.snapshot(i));
            for (DataSplit split : splits) {
                grouped.computeIfAbsent(new SplitInfo(split.partition(), split.bucket(), false, split.bucketPath(), split.deletionFiles().orElse(null)), k -> new ArrayList()).addAll(split.dataFiles());
            }
        }
        ArrayList<Split> result = new ArrayList<Split>();
        for (Map.Entry entry : grouped.entrySet()) {
            BinaryRow partition = ((SplitInfo)entry.getKey()).partition;
            int bucket = ((SplitInfo)entry.getKey()).bucket;
            boolean rawConvertible = ((SplitInfo)entry.getKey()).rawConvertible;
            String bucketPath = ((SplitInfo)entry.getKey()).bucketPath;
            List deletionFiles = ((SplitInfo)entry.getKey()).deletionFiles;
            for (SplitGenerator.SplitGroup splitGroup : reader.splitGenerator().splitForBatch((List)entry.getValue())) {
                DataSplit.Builder dataSplitBuilder = DataSplit.builder().withSnapshot(this.endingSnapshotId).withPartition(partition).withBucket(bucket).withDataFiles(splitGroup.files).rawConvertible(rawConvertible).withBucketPath(bucketPath);
                if (deletionFiles != null) {
                    dataSplitBuilder.withDataDeletionFiles(deletionFiles);
                }
                result.add(dataSplitBuilder.build());
            }
        }
        return StartingScanner.fromPlan(new PlanImpl(null, this.endingSnapshotId, result));
    }

    private List<DataSplit> readSplits(SnapshotReader reader, Snapshot s) {
        switch (this.scanMode) {
            case CHANGELOG: {
                return this.readChangeLogSplits(reader, s);
            }
            case DELTA: {
                return this.readDeltaSplits(reader, s);
            }
        }
        throw new UnsupportedOperationException("Unsupported scan kind: " + (Object)((Object)this.scanMode));
    }

    private List<DataSplit> readDeltaSplits(SnapshotReader reader, Snapshot s) {
        if (s.commitKind() != Snapshot.CommitKind.APPEND) {
            return Collections.emptyList();
        }
        return reader.withSnapshot(s).withMode(ScanMode.DELTA).read().splits();
    }

    private List<DataSplit> readChangeLogSplits(SnapshotReader reader, Snapshot s) {
        if (s.commitKind() == Snapshot.CommitKind.OVERWRITE) {
            return Collections.emptyList();
        }
        return reader.withSnapshot(s).withMode(ScanMode.CHANGELOG).read().splits();
    }

    private static class SplitInfo {
        private final BinaryRow partition;
        private final int bucket;
        private final boolean rawConvertible;
        private final String bucketPath;
        @Nullable
        private final List<DeletionFile> deletionFiles;

        private SplitInfo(BinaryRow partition, int bucket, boolean rawConvertible, String bucketPath, @Nullable List<DeletionFile> deletionFiles) {
            this.partition = partition;
            this.bucket = bucket;
            this.rawConvertible = rawConvertible;
            this.bucketPath = bucketPath;
            this.deletionFiles = deletionFiles;
        }

        public int hashCode() {
            return Arrays.hashCode(new Object[]{this.partition, this.bucket, this.rawConvertible, this.bucketPath, this.deletionFiles});
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SplitInfo)) {
                return false;
            }
            SplitInfo that = (SplitInfo)obj;
            return Objects.equals(this.partition, that.partition) && this.bucket == that.bucket && this.rawConvertible == that.rawConvertible && Objects.equals(this.bucketPath, that.bucketPath) && Objects.equals(this.deletionFiles, that.deletionFiles);
        }
    }
}

