/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.fileindex;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.paimon.fileindex.FileIndexFormat;
import org.apache.paimon.fileindex.FileIndexReader;
import org.apache.paimon.fs.ByteArraySeekableStream;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.fs.SeekableInputStream;
import org.apache.paimon.predicate.CompoundPredicate;
import org.apache.paimon.predicate.FieldRef;
import org.apache.paimon.predicate.LeafPredicate;
import org.apache.paimon.predicate.Or;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.predicate.PredicateVisitor;
import org.apache.paimon.types.RowType;

public class FileIndexPredicate
implements Closeable {
    private final FileIndexFormat.Reader reader;
    private final Map<String, FileIndexFieldPredicate> fieldPredicates = new HashMap<String, FileIndexFieldPredicate>();

    public FileIndexPredicate(Path path, FileIO fileIO, RowType fileRowType) throws IOException {
        this(fileIO.newInputStream(path), fileRowType);
    }

    public FileIndexPredicate(byte[] serializedBytes, RowType fileRowType) {
        this(new ByteArraySeekableStream(serializedBytes), fileRowType);
    }

    public FileIndexPredicate(SeekableInputStream inputStream, RowType fileRowType) {
        this.reader = FileIndexFormat.createReader(inputStream, fileRowType);
    }

    public boolean testPredicate(@Nullable Predicate filePredicate) {
        if (filePredicate == null) {
            return true;
        }
        Set<String> requredFieldNames = this.getRequiredNames(filePredicate);
        List testWorkers = requredFieldNames.stream().map(cname -> this.fieldPredicates.computeIfAbsent((String)cname, k -> new FileIndexFieldPredicate((String)cname, (Collection<FileIndexReader>)this.reader.readColumnIndex((String)cname)))).collect(Collectors.toList());
        for (FileIndexFieldPredicate testWorker : testWorkers) {
            if (testWorker.test(filePredicate).booleanValue()) continue;
            return false;
        }
        return true;
    }

    private Set<String> getRequiredNames(Predicate filePredicate) {
        return filePredicate.visit(new PredicateVisitor<Set<String>>(){
            final Set<String> names = new HashSet<String>();

            @Override
            public Set<String> visit(LeafPredicate predicate) {
                this.names.add(predicate.fieldName());
                return this.names;
            }

            @Override
            public Set<String> visit(CompoundPredicate predicate) {
                for (Predicate child : predicate.children()) {
                    child.visit(this);
                }
                return this.names;
            }
        });
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    private static class FileIndexFieldPredicate
    implements PredicateVisitor<Boolean> {
        private final String columnName;
        private final Collection<FileIndexReader> fileIndexReaders;

        public FileIndexFieldPredicate(String columnName, Collection<FileIndexReader> fileIndexReaders) {
            this.columnName = columnName;
            this.fileIndexReaders = fileIndexReaders;
        }

        public Boolean test(Predicate predicate) {
            return predicate.visit(this);
        }

        @Override
        public Boolean visit(LeafPredicate predicate) {
            if (this.columnName.equals(predicate.fieldName())) {
                FieldRef fieldRef = new FieldRef(predicate.index(), predicate.fieldName(), predicate.type());
                for (FileIndexReader fileIndexReader : this.fileIndexReaders) {
                    if (predicate.function().visit(fileIndexReader, fieldRef, predicate.literals()).booleanValue()) continue;
                    return false;
                }
            }
            return true;
        }

        @Override
        public Boolean visit(CompoundPredicate predicate) {
            if (predicate.function() instanceof Or) {
                for (Predicate predicate1 : predicate.children()) {
                    if (!predicate1.visit(this).booleanValue()) continue;
                    return true;
                }
                return false;
            }
            for (Predicate predicate1 : predicate.children()) {
                if (predicate1.visit(this).booleanValue()) continue;
                return false;
            }
            return true;
        }
    }
}

