/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.partition;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalArray;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.serializer.InternalSerializers;
import org.apache.paimon.data.serializer.Serializer;
import org.apache.paimon.format.FieldStats;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.predicate.PredicateBuilder;
import org.apache.paimon.statistics.FullFieldStatsCollector;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.InternalRowPartitionComputer;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.RowDataToObjectArrayConverter;

public interface PartitionPredicate {
    public boolean test(BinaryRow var1);

    public boolean test(long var1, InternalRow var3, InternalRow var4, InternalArray var5);

    @Nullable
    public static PartitionPredicate fromPredicate(RowType partitionType, Predicate predicate) {
        if (partitionType.getFieldCount() == 0 || predicate == null) {
            return null;
        }
        return new DefaultPartitionPredicate(predicate);
    }

    @Nullable
    public static PartitionPredicate fromMultiple(RowType partitionType, List<BinaryRow> partitions) {
        if (partitionType.getFieldCount() == 0 || partitions.isEmpty()) {
            return null;
        }
        return new MultiplePartitionPredicate(new RowDataToObjectArrayConverter(partitionType), new HashSet<BinaryRow>(partitions));
    }

    public static Predicate createPartitionPredicate(RowType rowType, Map<String, Object> partition) {
        PredicateBuilder builder = new PredicateBuilder(rowType);
        List<String> fieldNames = rowType.getFieldNames();
        Predicate predicate = null;
        for (Map.Entry<String, Object> entry : partition.entrySet()) {
            Predicate predicateTemp;
            Object literal = entry.getValue();
            int idx = fieldNames.indexOf(entry.getKey());
            Predicate predicate2 = predicateTemp = literal == null ? builder.isNull(idx) : builder.equal(idx, literal);
            if (predicate == null) {
                predicate = predicateTemp;
                continue;
            }
            predicate = PredicateBuilder.and(predicate, predicateTemp);
        }
        return predicate;
    }

    public static Predicate createPartitionPredicate(RowType partitionType, Object[] partition) {
        Preconditions.checkArgument(partition.length == partitionType.getFieldCount(), "Partition's field count should be equal to partitionType's field count.");
        HashMap<String, Object> partitionMap = new HashMap<String, Object>(partition.length);
        for (int i = 0; i < partition.length; ++i) {
            partitionMap.put(partitionType.getFields().get(i).name(), partition[i]);
        }
        return PartitionPredicate.createPartitionPredicate(partitionType, partitionMap);
    }

    public static Predicate createPartitionPredicate(RowType partitionType, BinaryRow partition) {
        Preconditions.checkArgument(partition.getFieldCount() == partitionType.getFieldCount(), "Partition's field count should be equal to partitionType's field count.");
        RowDataToObjectArrayConverter converter = new RowDataToObjectArrayConverter(partitionType);
        return PartitionPredicate.createPartitionPredicate(partitionType, converter.convert(partition));
    }

    @Nullable
    public static Predicate createPartitionPredicate(Map<String, String> spec, RowType rowType, String defaultPartValue) {
        Map<String, Object> internalValues = InternalRowPartitionComputer.convertSpecToInternal(spec, rowType, defaultPartValue);
        return PartitionPredicate.createPartitionPredicate(rowType, internalValues);
    }

    public static Predicate createPartitionPredicate(List<Map<String, String>> partitions, RowType rowType, String defaultPartValue) {
        return PredicateBuilder.or((Predicate[])partitions.stream().map(p -> PartitionPredicate.createPartitionPredicate(p, rowType, defaultPartValue)).toArray(Predicate[]::new));
    }

    public static class MultiplePartitionPredicate
    implements PartitionPredicate {
        private final Set<BinaryRow> partitions;
        private final int fieldNum;
        private final Predicate[] min;
        private final Predicate[] max;

        private MultiplePartitionPredicate(RowDataToObjectArrayConverter converter, Set<BinaryRow> partitions) {
            this.partitions = partitions;
            RowType partitionType = converter.rowType();
            this.fieldNum = partitionType.getFieldCount();
            Serializer[] serializers = new Serializer[this.fieldNum];
            FullFieldStatsCollector[] collectors = new FullFieldStatsCollector[this.fieldNum];
            this.min = new Predicate[this.fieldNum];
            this.max = new Predicate[this.fieldNum];
            for (int i = 0; i < this.fieldNum; ++i) {
                serializers[i] = InternalSerializers.create(partitionType.getTypeAt(i));
                collectors[i] = new FullFieldStatsCollector();
            }
            for (BinaryRow part : partitions) {
                Object[] fields = converter.convert(part);
                for (int i = 0; i < fields.length; ++i) {
                    collectors[i].collect(fields[i], serializers[i]);
                }
            }
            PredicateBuilder builder = new PredicateBuilder(partitionType);
            for (int i = 0; i < collectors.length; ++i) {
                FieldStats stats = collectors[i].result();
                if (stats.nullCount() == (long)partitions.size()) {
                    this.min[i] = builder.isNull(i);
                    this.max[i] = builder.isNull(i);
                    continue;
                }
                this.min[i] = builder.greaterOrEqual(i, Preconditions.checkNotNull(stats.minValue()));
                this.max[i] = builder.lessOrEqual(i, Preconditions.checkNotNull(stats.maxValue()));
                if (stats.nullCount() <= 0L) continue;
                this.min[i] = PredicateBuilder.or(builder.isNull(i), this.min[i]);
                this.max[i] = PredicateBuilder.or(builder.isNull(i), this.max[i]);
            }
        }

        @Override
        public boolean test(BinaryRow part) {
            return this.partitions.contains(part);
        }

        @Override
        public boolean test(long rowCount, InternalRow minValues, InternalRow maxValues, InternalArray nullCounts) {
            if (this.fieldNum == 0) {
                return true;
            }
            for (int i = 0; i < this.fieldNum; ++i) {
                if (this.min[i].test(rowCount, minValues, maxValues, nullCounts) && this.max[i].test(rowCount, minValues, maxValues, nullCounts)) continue;
                return false;
            }
            return true;
        }
    }

    public static class DefaultPartitionPredicate
    implements PartitionPredicate {
        private final Predicate predicate;

        private DefaultPartitionPredicate(Predicate predicate) {
            this.predicate = predicate;
        }

        @Override
        public boolean test(BinaryRow part) {
            return this.predicate.test(part);
        }

        @Override
        public boolean test(long rowCount, InternalRow minValues, InternalRow maxValues, InternalArray nullCounts) {
            return this.predicate.test(rowCount, minValues, maxValues, nullCounts);
        }
    }
}

