/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action;

import java.util.Map;
import java.util.Optional;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.paimon.flink.action.Action;
import org.apache.paimon.flink.action.ActionFactory;
import org.apache.paimon.flink.action.CreateBranchAction;
import org.apache.paimon.flink.action.MultipleParameterToolAdapter;

public class CreateBranchActionFactory
implements ActionFactory {
    public static final String IDENTIFIER = "create_branch";
    private static final String TAG_NAME = "tag_name";
    private static final String BRANCH_NAME = "branch_name";

    @Override
    public String identifier() {
        return IDENTIFIER;
    }

    @Override
    public Optional<Action> create(MultipleParameterToolAdapter params) {
        this.checkRequiredArgument(params, BRANCH_NAME);
        Tuple3<String, String, String> tablePath = this.getTablePath(params);
        Map<String, String> catalogConfig = this.optionalConfigMap(params, "catalog_conf");
        String tagName = null;
        if (params.has(TAG_NAME)) {
            tagName = params.get(TAG_NAME);
        }
        String branchName = params.get(BRANCH_NAME);
        CreateBranchAction action = new CreateBranchAction((String)tablePath.f0, (String)tablePath.f1, (String)tablePath.f2, catalogConfig, branchName, tagName);
        return Optional.of(action);
    }

    @Override
    public void printHelp() {
        System.out.println("Action \"create_branch\" create a branch from given tag.");
        System.out.println();
        System.out.println("Syntax:");
        System.out.println("  create_branch --warehouse <warehouse_path> --database <database_name> --table <table_name> --branch_name <branch_name> [--tag_name <tag_name>]");
        System.out.println();
    }
}

