/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.operation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.paimon.Snapshot;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.index.IndexFileHandler;
import org.apache.paimon.index.IndexFileMeta;
import org.apache.paimon.manifest.FileEntry;
import org.apache.paimon.manifest.FileKind;
import org.apache.paimon.manifest.IndexManifestEntry;
import org.apache.paimon.manifest.ManifestEntry;
import org.apache.paimon.manifest.ManifestFile;
import org.apache.paimon.manifest.ManifestFileMeta;
import org.apache.paimon.manifest.ManifestList;
import org.apache.paimon.stats.StatsFileHandler;
import org.apache.paimon.utils.FileDeletionThreadPool;
import org.apache.paimon.utils.FileStorePathFactory;
import org.apache.paimon.utils.Pair;
import org.apache.paimon.utils.SnapshotManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FileDeletionBase<T extends Snapshot> {
    private static final Logger LOG = LoggerFactory.getLogger(FileDeletionBase.class);
    protected final FileIO fileIO;
    protected final FileStorePathFactory pathFactory;
    protected final ManifestFile manifestFile;
    protected final ManifestList manifestList;
    protected final IndexFileHandler indexFileHandler;
    protected final StatsFileHandler statsFileHandler;
    private final boolean cleanEmptyDirectories;
    protected final Map<BinaryRow, Set<Integer>> deletionBuckets;
    private final Executor deleteFileExecutor;
    protected boolean changelogDecoupled;
    private long cachedTag = 0L;
    private final Map<BinaryRow, Map<Integer, Set<String>>> cachedTagDataFiles = new HashMap<BinaryRow, Map<Integer, Set<String>>>();

    public FileDeletionBase(FileIO fileIO, FileStorePathFactory pathFactory, ManifestFile manifestFile, ManifestList manifestList, IndexFileHandler indexFileHandler, StatsFileHandler statsFileHandler, boolean cleanEmptyDirectories, int deleteFileThreadNum) {
        this.fileIO = fileIO;
        this.pathFactory = pathFactory;
        this.manifestFile = manifestFile;
        this.manifestList = manifestList;
        this.indexFileHandler = indexFileHandler;
        this.statsFileHandler = statsFileHandler;
        this.cleanEmptyDirectories = cleanEmptyDirectories;
        this.deletionBuckets = new HashMap<BinaryRow, Set<Integer>>();
        this.deleteFileExecutor = FileDeletionThreadPool.getExecutorService(deleteFileThreadNum);
    }

    public abstract void cleanUnusedDataFiles(T var1, Predicate<ManifestEntry> var2);

    public abstract void cleanUnusedManifests(T var1, Set<String> var2);

    public void setChangelogDecoupled(boolean changelogDecoupled) {
        this.changelogDecoupled = changelogDecoupled;
    }

    public void cleanEmptyDirectories() {
        if (!this.cleanEmptyDirectories || this.deletionBuckets.isEmpty()) {
            return;
        }
        HashMap<Integer, Set> deduplicate = new HashMap<Integer, Set>();
        for (Map.Entry<BinaryRow, Set<Integer>> entry : this.deletionBuckets.entrySet()) {
            ArrayList<Path> toDeleteEmptyDirectory = new ArrayList<Path>();
            for (Integer bucket : entry.getValue()) {
                toDeleteEmptyDirectory.add(this.pathFactory.bucketPath(entry.getKey(), bucket));
            }
            this.deleteFiles(toDeleteEmptyDirectory, this::tryDeleteEmptyDirectory);
            List<Path> hierarchicalPaths = this.pathFactory.getHierarchicalPartitionPath(entry.getKey());
            int hierarchies = hierarchicalPaths.size();
            if (hierarchies == 0 || !this.tryDeleteEmptyDirectory(hierarchicalPaths.get(hierarchies - 1))) continue;
            for (int hierarchy = 0; hierarchy < hierarchies - 1; ++hierarchy) {
                Path path = hierarchicalPaths.get(hierarchy);
                deduplicate.computeIfAbsent(hierarchy, i -> new HashSet()).add(path);
            }
        }
        for (int hierarchy = deduplicate.size() - 1; hierarchy >= 0; --hierarchy) {
            ((Set)deduplicate.get(hierarchy)).forEach(this::tryDeleteEmptyDirectory);
        }
        this.deletionBuckets.clear();
    }

    protected void recordDeletionBuckets(ManifestEntry entry) {
        this.deletionBuckets.computeIfAbsent(entry.partition(), p -> new HashSet()).add(entry.bucket());
    }

    public void cleanUnusedDataFiles(String manifestList, Predicate<ManifestEntry> skipper) {
        List<String> manifestFileNames = this.readManifestFileNames(this.tryReadManifestList(manifestList));
        HashMap<Path, Pair<ManifestEntry, List<Path>>> dataFileToDelete = new HashMap<Path, Pair<ManifestEntry, List<Path>>>();
        for (String manifest : manifestFileNames) {
            List<ManifestEntry> manifestEntries;
            try {
                manifestEntries = this.manifestFile.read(manifest);
            }
            catch (Exception e) {
                LOG.warn("Failed to read some manifest files. Cancel deletion.", (Throwable)e);
                return;
            }
            this.getDataFileToDelete(dataFileToDelete, manifestEntries);
        }
        this.doCleanUnusedDataFile(dataFileToDelete, skipper);
    }

    protected void doCleanUnusedDataFile(Map<Path, Pair<ManifestEntry, List<Path>>> dataFileToDelete, Predicate<ManifestEntry> skipper) {
        ArrayList actualDataFileToDelete = new ArrayList();
        dataFileToDelete.forEach((path, pair) -> {
            ManifestEntry entry = (ManifestEntry)pair.getLeft();
            if (!skipper.test(entry)) {
                actualDataFileToDelete.add(path);
                actualDataFileToDelete.addAll((Collection)pair.getRight());
                this.recordDeletionBuckets(entry);
            }
        });
        this.deleteFiles(actualDataFileToDelete, this.fileIO::deleteQuietly);
    }

    protected void getDataFileToDelete(Map<Path, Pair<ManifestEntry, List<Path>>> dataFileToDelete, List<ManifestEntry> dataFileEntries) {
        block4: for (ManifestEntry entry : dataFileEntries) {
            Path bucketPath = this.pathFactory.bucketPath(entry.partition(), entry.bucket());
            Path dataFilePath = new Path(bucketPath, entry.file().fileName());
            switch (entry.kind()) {
                case ADD: {
                    dataFileToDelete.remove(dataFilePath);
                    continue block4;
                }
                case DELETE: {
                    ArrayList<Path> extraFiles = new ArrayList<Path>(entry.file().extraFiles().size());
                    for (String file : entry.file().extraFiles()) {
                        extraFiles.add(new Path(bucketPath, file));
                    }
                    dataFileToDelete.put(dataFilePath, Pair.of(entry, extraFiles));
                    continue block4;
                }
            }
            throw new UnsupportedOperationException("Unknown value kind " + entry.kind().name());
        }
    }

    public void deleteAddedDataFiles(String manifestListName) {
        List<String> manifestFileNames = this.readManifestFileNames(this.tryReadManifestList(manifestListName));
        for (String file : manifestFileNames) {
            try {
                List<ManifestEntry> manifestEntries = this.manifestFile.read(file);
                this.deleteAddedDataFiles(manifestEntries);
            }
            catch (Exception e) {
                LOG.info("Failed to read manifest " + file + ". Ignore it.", (Throwable)e);
            }
        }
    }

    private void deleteAddedDataFiles(List<ManifestEntry> manifestEntries) {
        ArrayList<Path> dataFileToDelete = new ArrayList<Path>();
        for (ManifestEntry entry : manifestEntries) {
            if (entry.kind() != FileKind.ADD) continue;
            dataFileToDelete.add(new Path(this.pathFactory.bucketPath(entry.partition(), entry.bucket()), entry.file().fileName()));
            this.recordDeletionBuckets(entry);
        }
        this.deleteFiles(dataFileToDelete, this.fileIO::deleteQuietly);
    }

    public void cleanUnusedStatisticsManifests(Snapshot snapshot, Set<String> skippingSet) {
        if (snapshot.statistics() != null && !skippingSet.contains(snapshot.statistics())) {
            this.statsFileHandler.deleteStats(snapshot.statistics());
        }
    }

    public void cleanUnusedIndexManifests(Snapshot snapshot, Set<String> skippingSet) {
        String indexManifest = snapshot.indexManifest();
        if (indexManifest != null && this.indexFileHandler.existsManifest(indexManifest)) {
            List<IndexManifestEntry> indexManifestEntries = this.indexFileHandler.readManifest(indexManifest);
            indexManifestEntries.removeIf(entry -> skippingSet.contains(entry.indexFile().fileName()));
            this.deleteFiles(indexManifestEntries, this.indexFileHandler::deleteIndexFile);
            if (!skippingSet.contains(indexManifest)) {
                this.indexFileHandler.deleteManifest(indexManifest);
            }
        }
    }

    public void cleanUnusedManifestList(String manifestName, Set<String> skippingSet) {
        ArrayList<String> toDeleteManifests = new ArrayList<String>();
        List<ManifestFileMeta> toExpireManifests = this.tryReadManifestList(manifestName);
        for (ManifestFileMeta manifest : toExpireManifests) {
            String fileName = manifest.fileName();
            if (skippingSet.contains(fileName)) continue;
            toDeleteManifests.add(fileName);
            skippingSet.add(fileName);
        }
        if (!skippingSet.contains(manifestName)) {
            toDeleteManifests.add(manifestName);
        }
        this.deleteFiles(toDeleteManifests, this.manifestFile::delete);
    }

    protected void cleanUnusedManifests(Snapshot snapshot, Set<String> skippingSet, boolean deleteDataManifestLists, boolean deleteChangelog) {
        if (deleteDataManifestLists) {
            this.cleanUnusedManifestList(snapshot.baseManifestList(), skippingSet);
            this.cleanUnusedManifestList(snapshot.deltaManifestList(), skippingSet);
        }
        if (deleteChangelog && snapshot.changelogManifestList() != null) {
            this.cleanUnusedManifestList(snapshot.changelogManifestList(), skippingSet);
        }
        this.cleanUnusedIndexManifests(snapshot, skippingSet);
        this.cleanUnusedStatisticsManifests(snapshot, skippingSet);
    }

    public Predicate<ManifestEntry> createDataFileSkipperForTags(List<Snapshot> taggedSnapshots, long expiringSnapshotId) throws Exception {
        int index = SnapshotManager.findPreviousSnapshot(taggedSnapshots, expiringSnapshotId);
        if (index >= 0) {
            Snapshot previousTag = taggedSnapshots.get(index);
            if (previousTag.id() != this.cachedTag) {
                this.cachedTag = previousTag.id();
                this.cachedTagDataFiles.clear();
                this.addMergedDataFiles(this.cachedTagDataFiles, previousTag);
            }
            return entry -> this.containsDataFile(this.cachedTagDataFiles, (ManifestEntry)entry);
        }
        return entry -> false;
    }

    protected List<ManifestFileMeta> tryReadManifestList(String manifestListName) {
        try {
            return this.manifestList.read(manifestListName);
        }
        catch (Exception e) {
            LOG.warn("Failed to read manifest list file " + manifestListName, (Throwable)e);
            return Collections.emptyList();
        }
    }

    protected List<String> tryReadDataManifests(Snapshot snapshot) {
        List<ManifestFileMeta> manifestFileMetas = this.tryReadManifestList(snapshot.baseManifestList());
        manifestFileMetas.addAll(this.tryReadManifestList(snapshot.deltaManifestList()));
        return this.readManifestFileNames(manifestFileMetas);
    }

    protected List<String> readManifestFileNames(List<ManifestFileMeta> manifestFileMetas) {
        return manifestFileMetas.stream().map(ManifestFileMeta::fileName).collect(Collectors.toCollection(LinkedList::new));
    }

    protected void addMergedDataFiles(Map<BinaryRow, Map<Integer, Set<String>>> dataFiles, Snapshot snapshot) throws IOException {
        for (ManifestEntry entry : this.readMergedDataFiles(snapshot)) {
            dataFiles.computeIfAbsent(entry.partition(), p -> new HashMap()).computeIfAbsent(entry.bucket(), b -> new HashSet()).add(entry.file().fileName());
        }
    }

    protected Collection<ManifestEntry> readMergedDataFiles(Snapshot snapshot) throws IOException {
        List<String> files = this.tryReadDataManifests(snapshot);
        HashMap map = new HashMap();
        for (String manifest : files) {
            List entries = this.manifestFile.readWithIOException(manifest);
            FileEntry.mergeEntries(entries, map);
        }
        return map.values();
    }

    protected boolean containsDataFile(Map<BinaryRow, Map<Integer, Set<String>>> dataFiles, ManifestEntry testee) {
        Set<String> fileNames;
        Map<Integer, Set<String>> buckets = dataFiles.get(testee.partition());
        if (buckets != null && (fileNames = buckets.get(testee.bucket())) != null) {
            return fileNames.contains(testee.file().fileName());
        }
        return false;
    }

    public Set<String> manifestSkippingSet(Snapshot skippingSnapshot) {
        return this.manifestSkippingSet(Collections.singletonList(skippingSnapshot));
    }

    public Set<String> manifestSkippingSet(List<Snapshot> skippingSnapshots) {
        HashSet<String> skippingSet = new HashSet<String>();
        for (Snapshot skippingSnapshot : skippingSnapshots) {
            skippingSet.add(skippingSnapshot.baseManifestList());
            skippingSet.add(skippingSnapshot.deltaManifestList());
            this.manifestList.readDataManifests(skippingSnapshot).stream().map(ManifestFileMeta::fileName).forEach(skippingSet::add);
            String indexManifest = skippingSnapshot.indexManifest();
            if (indexManifest != null) {
                skippingSet.add(indexManifest);
                this.indexFileHandler.readManifest(indexManifest).stream().map(IndexManifestEntry::indexFile).map(IndexFileMeta::fileName).forEach(skippingSet::add);
            }
            if (skippingSnapshot.statistics() == null) continue;
            skippingSet.add(skippingSnapshot.statistics());
        }
        return skippingSet;
    }

    private boolean tryDeleteEmptyDirectory(Path path) {
        try {
            this.fileIO.delete(path, false);
            return true;
        }
        catch (IOException e) {
            LOG.debug("Failed to delete directory '{}'. Check whether it is empty.", (Object)path);
            return false;
        }
    }

    protected <F> void deleteFiles(Collection<F> files, Consumer<F> deletion) {
        if (files.isEmpty()) {
            return;
        }
        ArrayList<CompletableFuture<Void>> deletionFutures = new ArrayList<CompletableFuture<Void>>(files.size());
        for (Object file : files) {
            deletionFutures.add(CompletableFuture.runAsync(() -> deletion.accept(file), this.deleteFileExecutor));
        }
        try {
            CompletableFuture.allOf(deletionFutures.toArray(new CompletableFuture[0])).get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

