/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.paimon.FileStore;
import org.apache.paimon.fs.Path;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.manifest.ManifestCacheFilter;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.stats.SimpleStats;
import org.apache.paimon.table.BucketMode;
import org.apache.paimon.table.BucketSpec;
import org.apache.paimon.table.CatalogEnvironment;
import org.apache.paimon.table.DataTable;
import org.apache.paimon.table.query.LocalTableQuery;
import org.apache.paimon.table.sink.RowKeyExtractor;
import org.apache.paimon.table.sink.TableCommitImpl;
import org.apache.paimon.table.sink.TableWriteImpl;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.SegmentsCache;

public interface FileStoreTable
extends DataTable {
    public void setManifestCache(SegmentsCache<Path> var1);

    @Override
    default public RowType rowType() {
        return this.schema().logicalRowType();
    }

    @Override
    default public List<String> partitionKeys() {
        return this.schema().partitionKeys();
    }

    @Override
    default public List<String> primaryKeys() {
        return this.schema().primaryKeys();
    }

    default public BucketSpec bucketSpec() {
        return new BucketSpec(this.bucketMode(), this.schema().bucketKeys(), this.schema().numBuckets());
    }

    default public BucketMode bucketMode() {
        return this.store().bucketMode();
    }

    @Override
    default public Map<String, String> options() {
        return this.schema().options();
    }

    @Override
    default public Optional<String> comment() {
        return Optional.ofNullable(this.schema().comment());
    }

    public TableSchema schema();

    public FileStore<?> store();

    public CatalogEnvironment catalogEnvironment();

    @Override
    public FileStoreTable copy(Map<String, String> var1);

    public FileStoreTable copy(TableSchema var1);

    public FileStoreTable copyWithoutTimeTravel(Map<String, String> var1);

    public FileStoreTable copyWithLatestSchema();

    @Override
    public TableWriteImpl<?> newWrite(String var1);

    public TableWriteImpl<?> newWrite(String var1, ManifestCacheFilter var2);

    @Override
    public TableCommitImpl newCommit(String var1);

    public LocalTableQuery newLocalTableQuery();

    default public SimpleStats getSchemaFieldStats(DataFileMeta dataFileMeta) {
        return dataFileMeta.valueStats();
    }

    public boolean supportStreamingReadOverwrite();

    public RowKeyExtractor createRowKeyExtractor();

    @Override
    public FileStoreTable switchToBranch(String var1);
}

