/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc.format;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.util.Collector;
import org.apache.paimon.flink.action.cdc.CdcSourceRecord;
import org.apache.paimon.flink.action.cdc.ComputedColumn;
import org.apache.paimon.flink.action.cdc.TypeMapping;
import org.apache.paimon.flink.sink.cdc.CdcRecord;
import org.apache.paimon.flink.sink.cdc.RichCdcMultiplexRecord;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.RowKind;
import org.apache.paimon.types.RowType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRecordParser
implements FlatMapFunction<CdcSourceRecord, RichCdcMultiplexRecord> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractRecordParser.class);
    protected static final String FIELD_TABLE = "table";
    protected static final String FIELD_DATABASE = "database";
    protected final TypeMapping typeMapping;
    protected final List<ComputedColumn> computedColumns;

    public AbstractRecordParser(TypeMapping typeMapping, List<ComputedColumn> computedColumns) {
        this.typeMapping = typeMapping;
        this.computedColumns = computedColumns;
    }

    @Nullable
    public Schema buildSchema(CdcSourceRecord record) {
        try {
            this.setRoot(record);
            if (this.isDDL()) {
                return null;
            }
            Optional recordOpt = this.extractRecords().stream().findFirst();
            if (!recordOpt.isPresent()) {
                return null;
            }
            Schema.Builder builder = Schema.newBuilder();
            ((RichCdcMultiplexRecord)recordOpt.get()).fields().forEach(field -> builder.column(field.name(), field.type(), field.description()));
            builder.primaryKey(this.extractPrimaryKeys());
            return builder.build();
        }
        catch (Exception e) {
            this.logInvalidSourceRecord(record);
            throw e;
        }
    }

    public void flatMap(CdcSourceRecord value, Collector<RichCdcMultiplexRecord> out) {
        try {
            this.setRoot(value);
            this.extractRecords().forEach(arg_0 -> out.collect(arg_0));
        }
        catch (Exception e) {
            this.logInvalidSourceRecord(value);
            throw e;
        }
    }

    protected abstract void setRoot(CdcSourceRecord var1);

    protected abstract List<RichCdcMultiplexRecord> extractRecords();

    protected boolean isDDL() {
        return false;
    }

    protected abstract List<String> extractPrimaryKeys();

    protected void evalComputedColumns(Map<String, String> rowData, RowType.Builder rowTypeBuilder) {
        this.computedColumns.forEach(computedColumn -> {
            rowData.put(computedColumn.columnName(), computedColumn.eval((String)rowData.get(computedColumn.fieldReference())));
            rowTypeBuilder.field(computedColumn.columnName(), computedColumn.columnType());
        });
    }

    protected RichCdcMultiplexRecord createRecord(RowKind rowKind, Map<String, String> data, List<DataField> paimonFields) {
        return new RichCdcMultiplexRecord(this.getDatabaseName(), this.getTableName(), paimonFields, this.extractPrimaryKeys(), new CdcRecord(rowKind, data));
    }

    @Nullable
    protected abstract String getTableName();

    @Nullable
    protected abstract String getDatabaseName();

    private void logInvalidSourceRecord(CdcSourceRecord record) {
        LOG.error("Invalid source record:\n{}", (Object)record.toString());
    }

    protected abstract String format();
}

