/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink.cdc;

import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.functions.ProcessFunction;
import org.apache.flink.util.Collector;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.CatalogLoader;
import org.apache.paimon.flink.sink.cdc.CdcMultiplexRecord;
import org.apache.paimon.flink.sink.cdc.CdcRecord;

public class CaseSensitiveUtils {
    public static DataStream<CdcRecord> cdcRecordConvert(CatalogLoader catalogLoader, DataStream<CdcRecord> input) {
        if (CaseSensitiveUtils.caseSensitive(catalogLoader)) {
            return input;
        }
        return input.forward().process((ProcessFunction)new ProcessFunction<CdcRecord, CdcRecord>(){

            public void processElement(CdcRecord record, ProcessFunction.Context ctx, Collector<CdcRecord> out) {
                out.collect((Object)record.fieldNameLowerCase());
            }
        }).name("Case-insensitive Convert");
    }

    public static DataStream<CdcMultiplexRecord> cdcMultiplexRecordConvert(CatalogLoader catalogLoader, DataStream<CdcMultiplexRecord> input) {
        if (CaseSensitiveUtils.caseSensitive(catalogLoader)) {
            return input;
        }
        return input.forward().process((ProcessFunction)new ProcessFunction<CdcMultiplexRecord, CdcMultiplexRecord>(){

            public void processElement(CdcMultiplexRecord record, ProcessFunction.Context ctx, Collector<CdcMultiplexRecord> out) {
                out.collect((Object)record.fieldNameLowerCase());
            }
        }).name("Case-insensitive Convert");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean caseSensitive(CatalogLoader catalogLoader) {
        try (Catalog catalog = catalogLoader.load();){
            boolean bl = catalog.caseSensitive();
            return bl;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

