/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink.cdc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.paimon.flink.action.cdc.CdcActionCommonUtils;
import org.apache.paimon.flink.action.cdc.CdcMetadataConverter;
import org.apache.paimon.flink.sink.cdc.RichCdcMultiplexRecord;
import org.apache.paimon.schema.Schema;

public class NewTableSchemaBuilder
implements Serializable {
    private final Map<String, String> tableConfig;
    private final boolean caseSensitive;
    private final List<String> partitionKeys;
    private final List<String> primaryKeys;
    private final boolean requirePrimaryKeys;
    private final CdcMetadataConverter[] metadataConverters;
    private final Map<String, List<String>> partitionKeyMultiple;

    public NewTableSchemaBuilder(Map<String, String> tableConfig, boolean caseSensitive, List<String> partitionKeys, List<String> primaryKeys, boolean requirePrimaryKeys, Map<String, List<String>> partitionKeyMultiple, CdcMetadataConverter[] metadataConverters) {
        this.tableConfig = tableConfig;
        this.caseSensitive = caseSensitive;
        this.metadataConverters = metadataConverters;
        this.partitionKeys = partitionKeys;
        this.primaryKeys = primaryKeys;
        this.requirePrimaryKeys = requirePrimaryKeys;
        this.partitionKeyMultiple = partitionKeyMultiple;
    }

    public Optional<Schema> build(RichCdcMultiplexRecord record) {
        Schema sourceSchema = new Schema(record.fields(), Collections.emptyList(), record.primaryKeys(), Collections.emptyMap(), null);
        List<Object> specifiedPartitionKeys = new ArrayList();
        List<String> partitionKeyMultipleList = this.partitionKeyMultiple.get(record.tableName());
        if (partitionKeyMultipleList != null && !partitionKeyMultipleList.isEmpty()) {
            specifiedPartitionKeys = partitionKeyMultipleList;
        } else if (this.partitionKeys != null && !this.partitionKeys.isEmpty()) {
            specifiedPartitionKeys = this.partitionKeys;
        }
        return Optional.of(CdcActionCommonUtils.buildPaimonSchema(record.tableName(), specifiedPartitionKeys, this.primaryKeys, Collections.emptyList(), this.tableConfig, sourceSchema, this.metadataConverters, this.caseSensitive, false, this.requirePrimaryKeys));
    }
}

