/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.manifest;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.apache.paimon.annotation.Public;
import org.apache.paimon.manifest.ManifestFileMetaSerializer;
import org.apache.paimon.stats.SimpleStats;
import org.apache.paimon.types.BigIntType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.RowType;
import org.apache.paimon.types.VarCharType;

@Public
public class ManifestFileMeta {
    public static final RowType SCHEMA = new RowType(false, Arrays.asList(new DataField(0, "_FILE_NAME", new VarCharType(false, Integer.MAX_VALUE)), new DataField(1, "_FILE_SIZE", new BigIntType(false)), new DataField(2, "_NUM_ADDED_FILES", new BigIntType(false)), new DataField(3, "_NUM_DELETED_FILES", new BigIntType(false)), new DataField(4, "_PARTITION_STATS", SimpleStats.SCHEMA), new DataField(5, "_SCHEMA_ID", new BigIntType(false))));
    private final String fileName;
    private final long fileSize;
    private final long numAddedFiles;
    private final long numDeletedFiles;
    private final SimpleStats partitionStats;
    private final long schemaId;
    private static final ThreadLocal<ManifestFileMetaSerializer> SERIALIZER_THREAD_LOCAL = ThreadLocal.withInitial(ManifestFileMetaSerializer::new);

    public ManifestFileMeta(String fileName, long fileSize, long numAddedFiles, long numDeletedFiles, SimpleStats partitionStats, long schemaId) {
        this.fileName = fileName;
        this.fileSize = fileSize;
        this.numAddedFiles = numAddedFiles;
        this.numDeletedFiles = numDeletedFiles;
        this.partitionStats = partitionStats;
        this.schemaId = schemaId;
    }

    public String fileName() {
        return this.fileName;
    }

    public long fileSize() {
        return this.fileSize;
    }

    public long numAddedFiles() {
        return this.numAddedFiles;
    }

    public long numDeletedFiles() {
        return this.numDeletedFiles;
    }

    public SimpleStats partitionStats() {
        return this.partitionStats;
    }

    public long schemaId() {
        return this.schemaId;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ManifestFileMeta)) {
            return false;
        }
        ManifestFileMeta that = (ManifestFileMeta)o;
        return Objects.equals(this.fileName, that.fileName) && this.fileSize == that.fileSize && this.numAddedFiles == that.numAddedFiles && this.numDeletedFiles == that.numDeletedFiles && Objects.equals(this.partitionStats, that.partitionStats) && this.schemaId == that.schemaId;
    }

    public int hashCode() {
        return Objects.hash(this.fileName, this.fileSize, this.numAddedFiles, this.numDeletedFiles, this.partitionStats, this.schemaId);
    }

    public String toString() {
        return String.format("{%s, %d, %d, %d, %s, %d}", this.fileName, this.fileSize, this.numAddedFiles, this.numDeletedFiles, this.partitionStats, this.schemaId);
    }

    public byte[] toBytes() throws IOException {
        return SERIALIZER_THREAD_LOCAL.get().serializeToBytes(this);
    }

    public ManifestFileMeta fromBytes(byte[] bytes) throws IOException {
        return (ManifestFileMeta)SERIALIZER_THREAD_LOCAL.get().deserializeFromBytes(bytes);
    }
}

