/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.stats;

import java.util.Optional;
import org.apache.paimon.Snapshot;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.stats.Statistics;
import org.apache.paimon.stats.StatsFile;
import org.apache.paimon.utils.SnapshotManager;

public class StatsFileHandler {
    private final SnapshotManager snapshotManager;
    private final SchemaManager schemaManager;
    private final StatsFile statsFile;

    public StatsFileHandler(SnapshotManager snapshotManager, SchemaManager schemaManager, StatsFile statsFile) {
        this.snapshotManager = snapshotManager;
        this.schemaManager = schemaManager;
        this.statsFile = statsFile;
    }

    public String writeStats(Statistics stats) {
        stats.serializeFieldsToString(this.schemaManager.schema(stats.schemaId()));
        return this.statsFile.write(stats);
    }

    public Optional<Statistics> readStats() {
        Long latestSnapshotId = this.snapshotManager.latestSnapshotId();
        if (latestSnapshotId == null) {
            throw new IllegalStateException("Unable to obtain the latest snapshot");
        }
        return this.readStats(latestSnapshotId);
    }

    public Optional<Statistics> readStats(long snapshotId) {
        return this.readStats(this.snapshotManager.snapshot(snapshotId));
    }

    public Optional<Statistics> readStats(Snapshot snapshot) {
        String file = snapshot.statistics();
        return file == null ? Optional.empty() : Optional.of(this.readStats(file));
    }

    public Statistics readStats(String file) {
        Statistics stats = this.statsFile.read(file);
        stats.deserializeFieldsFromString(this.schemaManager.schema(stats.schemaId()));
        return stats;
    }

    public void deleteStats(long snapshotId) {
        Snapshot snapshot = this.snapshotManager.snapshot(snapshotId);
        if (snapshot.statistics() != null) {
            this.statsFile.delete(snapshot.statistics());
        }
    }

    public void deleteStats(String statistic) {
        this.statsFile.delete(statistic);
    }
}

