/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.casting;

import org.apache.paimon.casting.AbstractCastRule;
import org.apache.paimon.casting.CastExecutor;
import org.apache.paimon.casting.CastRulePredicate;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeFamily;
import org.apache.paimon.utils.BinaryStringUtils;

class NumericToStringCastRule
extends AbstractCastRule<Object, BinaryString> {
    static final NumericToStringCastRule INSTANCE = new NumericToStringCastRule();

    private NumericToStringCastRule() {
        super(CastRulePredicate.builder().input(DataTypeFamily.NUMERIC).target(DataTypeFamily.CHARACTER_STRING).build());
    }

    @Override
    public CastExecutor<Object, BinaryString> create(DataType inputType, DataType targetType) {
        return value -> BinaryStringUtils.toCharacterString(BinaryString.fromString(value.toString()), targetType);
    }
}

