/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.catalog;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.paimon.PagedList;
import org.apache.paimon.Snapshot;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.Database;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.catalog.PropertyChange;
import org.apache.paimon.partition.Partition;
import org.apache.paimon.partition.PartitionStatistics;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.schema.SchemaChange;
import org.apache.paimon.table.Instant;
import org.apache.paimon.table.Table;
import org.apache.paimon.table.TableSnapshot;
import org.apache.paimon.view.View;
import org.apache.paimon.view.ViewChange;

public abstract class DelegateCatalog
implements Catalog {
    protected final Catalog wrapped;

    public DelegateCatalog(Catalog wrapped) {
        this.wrapped = wrapped;
    }

    public Catalog wrapped() {
        return this.wrapped;
    }

    @Override
    public boolean caseSensitive() {
        return this.wrapped.caseSensitive();
    }

    @Override
    public Map<String, String> options() {
        return this.wrapped.options();
    }

    @Override
    public List<String> listDatabases() {
        return this.wrapped.listDatabases();
    }

    @Override
    public PagedList<String> listDatabasesPaged(Integer maxResults, String pageToken) {
        return this.wrapped.listDatabasesPaged(maxResults, pageToken);
    }

    @Override
    public void createDatabase(String name, boolean ignoreIfExists, Map<String, String> properties) throws Catalog.DatabaseAlreadyExistException {
        this.wrapped.createDatabase(name, ignoreIfExists, properties);
    }

    @Override
    public Database getDatabase(String name) throws Catalog.DatabaseNotExistException {
        return this.wrapped.getDatabase(name);
    }

    @Override
    public void dropDatabase(String name, boolean ignoreIfNotExists, boolean cascade) throws Catalog.DatabaseNotExistException, Catalog.DatabaseNotEmptyException {
        this.wrapped.dropDatabase(name, ignoreIfNotExists, cascade);
    }

    @Override
    public void alterDatabase(String name, List<PropertyChange> changes, boolean ignoreIfNotExists) throws Catalog.DatabaseNotExistException {
        this.wrapped.alterDatabase(name, changes, ignoreIfNotExists);
    }

    @Override
    public List<String> listTables(String databaseName) throws Catalog.DatabaseNotExistException {
        return this.wrapped.listTables(databaseName);
    }

    @Override
    public PagedList<String> listTablesPaged(String databaseName, Integer maxResults, String pageToken) throws Catalog.DatabaseNotExistException {
        return this.wrapped.listTablesPaged(databaseName, maxResults, pageToken);
    }

    @Override
    public PagedList<Table> listTableDetailsPaged(String databaseName, Integer maxResults, String pageToken) throws Catalog.DatabaseNotExistException {
        return this.wrapped.listTableDetailsPaged(databaseName, maxResults, pageToken);
    }

    @Override
    public void dropTable(Identifier identifier, boolean ignoreIfNotExists) throws Catalog.TableNotExistException {
        this.wrapped.dropTable(identifier, ignoreIfNotExists);
    }

    @Override
    public void createTable(Identifier identifier, Schema schema, boolean ignoreIfExists) throws Catalog.TableAlreadyExistException, Catalog.DatabaseNotExistException {
        this.wrapped.createTable(identifier, schema, ignoreIfExists);
    }

    @Override
    public void renameTable(Identifier fromTable, Identifier toTable, boolean ignoreIfNotExists) throws Catalog.TableNotExistException, Catalog.TableAlreadyExistException {
        this.wrapped.renameTable(fromTable, toTable, ignoreIfNotExists);
    }

    @Override
    public void alterTable(Identifier identifier, List<SchemaChange> changes, boolean ignoreIfNotExists) throws Catalog.TableNotExistException, Catalog.ColumnAlreadyExistException, Catalog.ColumnNotExistException {
        this.wrapped.alterTable(identifier, changes, ignoreIfNotExists);
    }

    @Override
    public boolean supportsListObjectsPaged() {
        return this.wrapped.supportsListObjectsPaged();
    }

    @Override
    public boolean supportsVersionManagement() {
        return this.wrapped.supportsVersionManagement();
    }

    @Override
    public Optional<TableSnapshot> loadSnapshot(Identifier identifier) throws Catalog.TableNotExistException {
        return this.wrapped.loadSnapshot(identifier);
    }

    @Override
    public void rollbackTo(Identifier identifier, Instant instant) throws Catalog.TableNotExistException {
        this.wrapped.rollbackTo(identifier, instant);
    }

    @Override
    public void createBranch(Identifier identifier, String branch, @Nullable String fromTag) throws Catalog.TableNotExistException, Catalog.BranchAlreadyExistException, Catalog.TagNotExistException {
        this.wrapped.createBranch(identifier, branch, fromTag);
    }

    @Override
    public void dropBranch(Identifier identifier, String branch) throws Catalog.BranchNotExistException {
        this.wrapped.dropBranch(identifier, branch);
    }

    @Override
    public void fastForward(Identifier identifier, String branch) throws Catalog.BranchNotExistException {
        this.wrapped.fastForward(identifier, branch);
    }

    @Override
    public List<String> listBranches(Identifier identifier) throws Catalog.TableNotExistException {
        return this.wrapped.listBranches(identifier);
    }

    @Override
    public boolean commitSnapshot(Identifier identifier, Snapshot snapshot, List<PartitionStatistics> statistics) throws Catalog.TableNotExistException {
        return this.wrapped.commitSnapshot(identifier, snapshot, statistics);
    }

    @Override
    public void createPartitions(Identifier identifier, List<Map<String, String>> partitions) throws Catalog.TableNotExistException {
        this.wrapped.createPartitions(identifier, partitions);
    }

    @Override
    public void dropPartitions(Identifier identifier, List<Map<String, String>> partitions) throws Catalog.TableNotExistException {
        this.wrapped.dropPartitions(identifier, partitions);
    }

    @Override
    public void alterPartitions(Identifier identifier, List<PartitionStatistics> partitions) throws Catalog.TableNotExistException {
        this.wrapped.alterPartitions(identifier, partitions);
    }

    @Override
    public void markDonePartitions(Identifier identifier, List<Map<String, String>> partitions) throws Catalog.TableNotExistException {
        this.wrapped.markDonePartitions(identifier, partitions);
    }

    @Override
    public Table getTable(Identifier identifier) throws Catalog.TableNotExistException {
        return this.wrapped.getTable(identifier);
    }

    @Override
    public View getView(Identifier identifier) throws Catalog.ViewNotExistException {
        return this.wrapped.getView(identifier);
    }

    @Override
    public void dropView(Identifier identifier, boolean ignoreIfNotExists) throws Catalog.ViewNotExistException {
        this.wrapped.dropView(identifier, ignoreIfNotExists);
    }

    @Override
    public void createView(Identifier identifier, View view, boolean ignoreIfExists) throws Catalog.ViewAlreadyExistException, Catalog.DatabaseNotExistException {
        this.wrapped.createView(identifier, view, ignoreIfExists);
    }

    @Override
    public List<String> listViews(String databaseName) throws Catalog.DatabaseNotExistException {
        return this.wrapped.listViews(databaseName);
    }

    @Override
    public PagedList<String> listViewsPaged(String databaseName, Integer maxResults, String pageToken) throws Catalog.DatabaseNotExistException {
        return this.wrapped.listViewsPaged(databaseName, maxResults, pageToken);
    }

    @Override
    public PagedList<View> listViewDetailsPaged(String databaseName, Integer maxResults, String pageToken) throws Catalog.DatabaseNotExistException {
        return this.wrapped.listViewDetailsPaged(databaseName, maxResults, pageToken);
    }

    @Override
    public void renameView(Identifier fromView, Identifier toView, boolean ignoreIfNotExists) throws Catalog.ViewNotExistException, Catalog.ViewAlreadyExistException {
        this.wrapped.renameView(fromView, toView, ignoreIfNotExists);
    }

    @Override
    public void alterView(Identifier view, List<ViewChange> viewChanges, boolean ignoreIfNotExists) throws Catalog.ViewNotExistException, Catalog.DialectAlreadyExistException, Catalog.DialectNotExistException {
        this.wrapped.alterView(view, viewChanges, ignoreIfNotExists);
    }

    @Override
    public List<Partition> listPartitions(Identifier identifier) throws Catalog.TableNotExistException {
        return this.wrapped.listPartitions(identifier);
    }

    @Override
    public PagedList<Partition> listPartitionsPaged(Identifier identifier, Integer maxResults, String pageToken) throws Catalog.TableNotExistException {
        return this.wrapped.listPartitionsPaged(identifier, maxResults, pageToken);
    }

    @Override
    public void repairCatalog() {
        this.wrapped.repairCatalog();
    }

    @Override
    public void repairDatabase(String databaseName) {
        this.wrapped.repairDatabase(databaseName);
    }

    @Override
    public void repairTable(Identifier identifier) throws Catalog.TableNotExistException {
        this.wrapped.repairTable(identifier);
    }

    @Override
    public void close() throws Exception {
        this.wrapped.close();
    }

    public static Catalog rootCatalog(Catalog catalog) {
        while (catalog instanceof DelegateCatalog) {
            catalog = ((DelegateCatalog)catalog).wrapped();
        }
        return catalog;
    }
}

